package transformers.udf;

import java.io.Serializable;

public class LogTransformerUdf implements TransformerUdf, Serializable {

  private static final long serialVersionUID = 3127275937665658889L;

  private static LogTransformerUdf instance = new LogTransformerUdf();

  private LogTransformerUdf() {
  }

  public static LogTransformerUdf getInstance() {

    return instance;
  }

  @Override
  public double applyAsDouble(final double featureValue) {

    return Math.log(featureValue);
  }

}
