package transformers.udf;


import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.sql.api.java.UDF1;

public class IndependentGaussianUdf implements UDF1 {

  private static final long serialVersionUID = -1807394765446140897L;

  double[] muValues;
  double[] sigmaValues;

  public IndependentGaussianUdf(double[] muValues, double[] sigmaValues) {

    this.muValues = muValues;
    this.sigmaValues = sigmaValues;
  }

  @Override
  public Object call(Object features) throws Exception {

    double[] arrayFeatures = ((DenseVector) features).toArray();

    Double[] gaussianValues = new Double[arrayFeatures.length];
    for (int index = 0; index < arrayFeatures.length; index++) {
      gaussianValues[index] = gaussian(arrayFeatures[index], muValues[index], sigmaValues[index]);
    }

    Double anomalyProb = 1.0;

    for (Double prob : gaussianValues) {
      anomalyProb *= prob;
    }

    anomalyProb =
        ((1.0 / (1 + Math.exp(-Math.pow(anomalyProb, 1.0 / arrayFeatures.length)))) * 2) - 1;

    return anomalyProb;
  }

  private Double gaussian(final Double value, final Double mu, final Double sigma) {

    double
        prob =
        (1.0 / (Math.sqrt(2 * Math.PI) * sigma)) * Math
            .exp(-Math.pow((value - mu) / (Math.sqrt(2) * sigma), 2));

    if (prob >= 1.0) {

      prob = 0.99;
    }

    return prob;
  }
}
