package transformers.udf;

import org.apache.spark.sql.api.java.UDF1;

public class FeaturesPreProcessingTransformerUdf implements UDF1 {

  private static final long serialVersionUID = 8620960560971947455L;

  final AbsTransformerUdf absTransformer;
  final LogTransformerUdf logTransformer;
  final ShiftTransformerUdf shiftTransformer;

  public FeaturesPreProcessingTransformerUdf(final double shiftValue) {

    absTransformer = AbsTransformerUdf.getInstance();
    logTransformer = LogTransformerUdf.getInstance();
    shiftTransformer = new ShiftTransformerUdf(shiftValue);
  }

  @Override
  public Object call(Object value) throws Exception {

    final Double
        preProcessedValue =
        logTransformer.applyAsDouble(shiftTransformer.applyAsDouble(
            absTransformer.applyAsDouble(Double.parseDouble(value.toString()))));

    return preProcessedValue;
  }
}