package transformers.udf;

import java.io.Serializable;

public class AbsTransformerUdf implements TransformerUdf, Serializable {

  private static final long serialVersionUID = -7766769349724995033L;

  private static final AbsTransformerUdf instance = new AbsTransformerUdf();

  private AbsTransformerUdf() {}

  public static AbsTransformerUdf getInstance() {

    return instance;
  }

  @Override
  public double applyAsDouble(final double featureValue) {

    return Math.abs(featureValue);
  }
}
