package transformers.udf;

import java.io.Serializable;

public class ShiftTransformerUdf implements TransformerUdf, Serializable {

  private static final long serialVersionUID = 1338291826612261010L;

  private final double shiftValue;

  public ShiftTransformerUdf(final double shiftValue) {
    this.shiftValue = shiftValue;
  }

  @Override
  public double applyAsDouble(final double featureValue) {

    return featureValue + shiftValue;
  }

}