package transformers.udf;

import org.apache.spark.sql.api.java.UDF1;

public class IndependentGaussianDecisionUdf implements UDF1 {

  private static final long serialVersionUID = -6526464027851254750L;

  private final double decisionThreshold;

  public IndependentGaussianDecisionUdf(final double decisionThreshold) {

    this.decisionThreshold = decisionThreshold;
  }

  @Override
  public Object call(Object obj) throws Exception {

    Double gaussianValue = (Double) obj;

    if (gaussianValue >= decisionThreshold) {

      return 1;
    } else {

      return 0;
    }
  }
}
