package metrics

import org.apache.spark.graphx.{EdgeTriplet, VertexId}

object SumValueSentCalculator {

  // Calculate the sum of values sent for each account
  def sumValue(vertexId: VertexId, value: (String, BigInt), message: BigInt): (String, BigInt) = {

    (value._1, value._2 + message)
  }

  def sendSentMsg(triplet: EdgeTriplet[(String, BigInt), (BigInt, Long, Long)]):
  Iterator[(VertexId, BigInt)] = {

    Iterator((triplet.srcId, triplet.attr._1))
  }

  def mergeMsg(msg1: BigInt, msg2: BigInt): BigInt = {

    msg1 + msg2
  }
}
