package metrics

import org.apache.spark.graphx.{EdgeTriplet, VertexId}

object DistanceCalculator {

  def distanceValue(vertexId: VertexId, value: (String, BigInt), message: BigInt):
  (String, BigInt) = {

    (value._1, math.min(message.longValue(), value._2.longValue()))
  }

  def sendDistanceMsg(triplet: EdgeTriplet[(String, BigInt), (BigInt, Long, Long)]):
  Iterator[(VertexId, BigInt)] = {

    val srcAttrs = triplet.srcAttr
    val dstAttrs = triplet.dstAttr

    if (srcAttrs._2 < Long.MaxValue && (srcAttrs._2 + 1) < dstAttrs._2) {
      Iterator((triplet.dstId, srcAttrs._2 + 1))
    }

    else {
      Iterator.empty
    }
  }

  def mergeDistanceMsgs(distance1: BigInt, distance2: BigInt): BigInt = {

    math.min(distance1.longValue(), distance2.longValue())
  }
}
