package readers;

import org.apache.commons.lang.ArrayUtils;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Row;

import java.util.List;
import java.util.logging.Logger;

import models.IndependentGaussianModel;

public class IndependentGaussianReader extends MLReader<IndependentGaussianModel> {

  private static final Logger LOGGER = Logger.getLogger(IndependentGaussianReader.class.getName());

  @Override
  public IndependentGaussianModel load(String path) {

    //String dataPath = new Path(path, "data").toString();
    Row
        row =
        sparkSession().read().parquet(path)
            .select("inputColName", "outProbColumnName", "outDecisionColumnName", "meanValues",
                    "stdValues",
                    "decisionThreshold")
            .head();
    String inputColName = row.getString(0);
    String outProbColumnName = row.getString(1);
    String outDecisionColumnName = row.getString(2);
    List<Double> listMeanValues = row.getList(3);
    List<Double> listStdValues = row.getList(4);
    double decisionThreshold = row.getDouble(5);
    Double[] meanValues = new Double[listMeanValues.size()];
    Double[] stdValues = new Double[listStdValues.size()];
    meanValues = listMeanValues.toArray(meanValues);
    stdValues = listStdValues.toArray(stdValues);

    IndependentGaussianModel
        model =
        new IndependentGaussianModel(inputColName, outProbColumnName, outDecisionColumnName,
                                     ArrayUtils.toPrimitive(meanValues),
                                     ArrayUtils.toPrimitive(stdValues), decisionThreshold);

    return model;
  }
}
