/*
 * Decompiled with CFR 0.152.
 */
package albelli.junit.synnefo.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lalbelli/junit/synnefo/runtime/ZipHelper;", "", "()V", "Companion", "junit.synnefo"})
public final class ZipHelper {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lalbelli/junit/synnefo/runtime/ZipHelper$Companion;", "", "()V", "newFile", "Ljava/io/File;", "destinationDir", "zipEntry", "Ljava/util/zip/ZipEntry;", "unzip", "", "fileZip", "Ljava/io/InputStream;", "dest", "", "", "junit.synnefo"})
    public static final class Companion {
        public final void unzip(@NotNull byte[] fileZip, @NotNull String dest) {
            Intrinsics.checkParameterIsNotNull((Object)fileZip, (String)"fileZip");
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            this.unzip(new ByteArrayInputStream(fileZip), dest);
        }

        public final void unzip(@NotNull InputStream fileZip, @NotNull String dest) {
            Intrinsics.checkParameterIsNotNull((Object)fileZip, (String)"fileZip");
            Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
            File destDir = new File(dest);
            destDir.mkdirs();
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(fileZip);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = this.newFile(destDir, zipEntry);
                FileOutputStream fos = new FileOutputStream(newFile);
                int len = 0;
                len = zis.read(buffer);
                while (len > 0) {
                    fos.write(buffer, 0, len);
                    len = zis.read(buffer);
                }
                fos.close();
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }

        private final File newFile(File destinationDir, ZipEntry zipEntry) {
            String destFilePath;
            File destFile = new File(destinationDir, zipEntry.getName());
            String destDirPath = destinationDir.getCanonicalPath();
            String string = destFilePath = destFile.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"destFilePath");
            if (!StringsKt.startsWith$default((String)string, (String)(destDirPath + File.separator), (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException("Entry is outside of the target dir: " + zipEntry.getName());
            }
            return destFile;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

