/*
 * Decompiled with CFR 0.152.
 */
package albelli.junit.synnefo.runtime;

import albelli.junit.synnefo.runtime.AmazonCodeBuildScheduler;
import albelli.junit.synnefo.runtime.AmazonCodeBuildScheduler$WhenMappings;
import albelli.junit.synnefo.runtime.SynnefoProperties;
import albelli.junit.synnefo.runtime.SynnefoRunnerInfo;
import albelli.junit.synnefo.runtime.exceptions.SynnefoTestFailureException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.ArtifactsType;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J2\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0006H\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010)\u001a\u00020\f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010+\u001a\u00020\f*\u00060,j\u0002`-2\u0006\u0010.\u001a\u00020\u0006H\u0002J&\u0010/\u001a\b\u0012\u0004\u0012\u0002H100\"\u0004\b\u0000\u00101*\b\u0012\u0004\u0012\u0002H1002\u0006\u00102\u001a\u000203H\u0002J,\u00104\u001a\u00020\f*\u00020\n2\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u000203H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler;", "", "settings", "Lalbelli/junit/synnefo/runtime/SynnefoProperties;", "(Lalbelli/junit/synnefo/runtime/SynnefoProperties;)V", "buildSpecTemplate", "", "codeBuild", "Lsoftware/amazon/awssdk/services/codebuild/CodeBuildClient;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "collectArtifacts", "", "runResults", "", "Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$ScheduledJob;", "createCodeBuildProject", "ensureProjectExists", "generateBuildspecForFeature", "jar", "feature", "runtimeOptions", "", "newFile", "Ljava/io/File;", "destinationDir", "zipEntry", "Ljava/util/zip/ZipEntry;", "projectExists", "", "projectName", "schedule", "job", "Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$Job;", "startBuilds", "sourceLocation", "unzip", "fileZip", "Ljava/io/InputStream;", "dest", "uploadToS3AndGetSourcePath", "waitForJobs", "jobs", "appendWithEscaping", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "s", "dequeueUpTo", "", "E", "limit", "", "multipartUploadFile", "bucket", "key", "filePath", "partSizeMb", "Job", "ScheduledJob", "junit.synnefo"})
public final class AmazonCodeBuildScheduler {
    private final S3Client s3;
    private final CodeBuildClient codeBuild;
    private final String buildSpecTemplate = "version: 0.2\n\nphases:\n  pre_build:\n    commands:\n      - echo Build started on `date`\n  build:\n    commands:\n      - mkdir result-artifacts\n      - cd result-artifacts\n      - %s\n      - ls\n  post_build:\n    commands:\n      - echo Build completed on `date`\nartifacts:\n  files:\n    - 'result-artifacts/**/*'\n  discard-paths: yes";
    private final SynnefoProperties settings;

    @NotNull
    public final List<ScheduledJob> schedule(@NotNull Job job) throws ExecutionException, InterruptedException {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        if (job.getFeaturePaths().isEmpty()) {
            return new ArrayList();
        }
        String sourceLocation = this.uploadToS3AndGetSourcePath(job, this.settings);
        this.ensureProjectExists(this.settings);
        return this.startBuilds(job, this.settings, sourceLocation);
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForJobs(@NotNull List<ScheduledJob> jobs) {
        Intrinsics.checkParameterIsNotNull(jobs, (String)"jobs");
        LinkedList<ScheduledJob> queue = new LinkedList<ScheduledJob>();
        queue.addAll((Collection)jobs);
        int limit = 100;
        while (!queue.isEmpty()) {
            void $receiver$iv$iv;
            String string;
            Object object;
            void $receiver$iv$iv2;
            Iterable $receiver$iv = queue;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterable iterable = $receiver$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv2) {
                ScheduledJob it;
                ScheduledJob scheduledJob = (ScheduledJob)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                string = it.getBuildId();
                it = (ScheduledJob)element$iv$iv;
                boolean bl2 = false;
                ScheduledJob scheduledJob2 = it;
                object.put(string, scheduledJob2);
            }
            Map lookupDict = destination$iv$iv;
            List dequeued = this.dequeueUpTo(queue, limit);
            Iterable $receiver$iv2 = dequeued;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ScheduledJob bl2 = (ScheduledJob)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                string = it.getBuildId();
                object.add(string);
            }
            List dequeuedIds = (List)destination$iv$iv2;
            dequeued.clear();
            BatchGetBuildsRequest request = (BatchGetBuildsRequest)BatchGetBuildsRequest.builder().ids((Collection)dequeuedIds).build();
            BatchGetBuildsResponse response = this.codeBuild.batchGetBuilds(request);
            for (Build build : response.builds()) {
                String string2 = build.id();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"build.id()");
                ScheduledJob originalJob = (ScheduledJob)MapsKt.getValue((Map)lookupDict, (Object)string2);
                StatusType statusType = build.buildStatus();
                if (statusType == null) {
                    Intrinsics.throwNpe();
                }
                switch (AmazonCodeBuildScheduler$WhenMappings.$EnumSwitchMapping$0[statusType.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        originalJob.getOriginalJob().getNotifier().fireTestFailure(new Failure(originalJob.getJunitDescription(), (Throwable)new SynnefoTestFailureException("Test " + originalJob.getInfo().getCucumberFeatureLocation())));
                        break;
                    }
                    case 5: {
                        originalJob.getOriginalJob().getNotifier().fireTestFinished(originalJob.getJunitDescription());
                        break;
                    }
                    case 6: {
                        queue.addLast(originalJob);
                        break;
                    }
                    case 7: {
                        throw (Throwable)new Exception("nao we die");
                    }
                }
            }
            Thread.sleep(2000L);
        }
    }

    public final void collectArtifacts(@NotNull List<ScheduledJob> runResults) {
        Intrinsics.checkParameterIsNotNull(runResults, (String)"runResults");
        String targetDirectory = this.settings.getSynnefoOptions().reportTargetDir();
        for (ScheduledJob result : runResults) {
            ResponseInputStream stream;
            String buildId;
            String string = result.getBuildId();
            int n = StringsKt.indexOf$default((CharSequence)result.getBuildId(), (char)':', (int)0, (boolean)false, (int)6, null) + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            String keyPath = this.settings.getSynnefoOptions().bucketOutputFolder() + buildId + '/' + this.settings.getSynnefoOptions().outputFileName();
            S3Request s3Request = GetObjectRequest.builder().bucket(this.settings.getSynnefoOptions().bucketName()).key(keyPath).build();
            if (s3Request == null) {
                Intrinsics.throwNpe();
            }
            GetObjectRequest getObjectRequest = (GetObjectRequest)s3Request;
            ResponseInputStream responseInputStream = stream = (ResponseInputStream)this.s3.getObject(getObjectRequest, ResponseTransformer.toInputStream());
            Intrinsics.checkExpressionValueIsNotNull((Object)responseInputStream, (String)"stream");
            this.unzip((InputStream)responseInputStream, targetDirectory);
        }
    }

    private final String generateBuildspecForFeature(String jar, String feature, Map<String, ? extends List<String>> runtimeOptions) {
        StringBuilder sb = new StringBuilder();
        this.appendWithEscaping(sb, "java");
        this.appendWithEscaping(sb, "-cp");
        this.appendWithEscaping(sb, "./../" + jar);
        this.appendWithEscaping(sb, "cucumber.api.cli.Main");
        this.appendWithEscaping(sb, "./../" + feature);
        runtimeOptions.forEach((BiConsumer<String, ? extends List<String>>)new BiConsumer<String, List<? extends String>>(this, sb){
            final /* synthetic */ AmazonCodeBuildScheduler this$0;
            final /* synthetic */ StringBuilder $sb;

            public final void accept(@NotNull String $noName_0, @NotNull List<String> values) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                Iterable $receiver$iv = values;
                for (T element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    AmazonCodeBuildScheduler.access$appendWithEscaping(this.this$0, this.$sb, it);
                }
            }
            {
                this.this$0 = amazonCodeBuildScheduler;
                this.$sb = stringBuilder;
            }
        });
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = this.buildSpecTemplate;
        Object[] objectArray = new Object[]{sb.toString()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private final String uploadToS3AndGetSourcePath(Job job, SynnefoProperties settings) throws ExecutionException, InterruptedException {
        Path jarPath;
        String targetDirectory = settings.getSynnefoOptions().bucketSourceFolder() + UUID.randomUUID() + "/";
        Path path = jarPath = Paths.get(job.getJarPath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"jarPath");
        String jarFileName = ((Object)path.getFileName()).toString();
        for (String feature : job.getFeaturePaths()) {
            this.multipartUploadFile(this.s3, settings.getSynnefoOptions().bucketName(), targetDirectory + feature, feature, 5);
        }
        this.multipartUploadFile(this.s3, settings.getSynnefoOptions().bucketName(), targetDirectory + jarFileName, job.getJarPath(), 5);
        return targetDirectory;
    }

    private final void ensureProjectExists(SynnefoProperties settings) throws ExecutionException, InterruptedException {
        if (this.projectExists(settings.getSynnefoOptions().projectName())) {
            return;
        }
        this.createCodeBuildProject(settings);
    }

    private final boolean projectExists(String projectName) throws ExecutionException, InterruptedException {
        BatchGetProjectsRequest batchGetProjectsRequest = (BatchGetProjectsRequest)BatchGetProjectsRequest.builder().names(new String[]{projectName}).build();
        BatchGetProjectsResponse response = this.codeBuild.batchGetProjects(batchGetProjectsRequest);
        return response.projects().size() == 1;
    }

    private final void createCodeBuildProject(SynnefoProperties settings) throws ExecutionException, InterruptedException {
        String sourceLocation = settings.getSynnefoOptions().bucketName() + "/" + settings.getSynnefoOptions().bucketSourceFolder();
        CreateProjectRequest createRequest2 = (CreateProjectRequest)CreateProjectRequest.builder().name(settings.getSynnefoOptions().projectName()).description("Autogenerated codebuild project to run tests").artifacts((Consumer)new Consumer<ProjectArtifacts.Builder>(settings){
            final /* synthetic */ SynnefoProperties $settings;

            public final void accept(ProjectArtifacts.Builder a) {
                a.type(ArtifactsType.S3).path(this.$settings.getSynnefoOptions().bucketOutputFolder()).name(this.$settings.getSynnefoOptions().outputFileName()).namespaceType("BUILD_ID").packaging("ZIP").location(this.$settings.getSynnefoOptions().bucketName());
            }
            {
                this.$settings = synnefoProperties;
            }
        }).cache((Consumer)createCodeBuildProject.createRequest.2.INSTANCE).environment((Consumer)new Consumer<ProjectEnvironment.Builder>(settings){
            final /* synthetic */ SynnefoProperties $settings;

            public final void accept(ProjectEnvironment.Builder b) {
                b.type(EnvironmentType.LINUX_CONTAINER).image(this.$settings.getSynnefoOptions().image()).computeType(this.$settings.getSynnefoOptions().computeType());
            }
            {
                this.$settings = synnefoProperties;
            }
        }).serviceRole(settings.getSynnefoOptions().serviceRole()).source((Consumer)new Consumer<ProjectSource.Builder>(sourceLocation){
            final /* synthetic */ String $sourceLocation;

            public final void accept(ProjectSource.Builder s) {
                s.type(SourceType.S3).location(this.$sourceLocation);
            }
            {
                this.$sourceLocation = string;
            }
        }).logsConfig((Consumer)new Consumer<LogsConfig.Builder>(settings){
            final /* synthetic */ SynnefoProperties $settings;

            public final void accept(LogsConfig.Builder l) {
                l.cloudWatchLogs((Consumer)new Consumer<CloudWatchLogsConfig.Builder>(this){
                    final /* synthetic */ createCodeBuildProject.createRequest.5 this$0;

                    public final void accept(CloudWatchLogsConfig.Builder cwl) {
                        cwl.groupName("/aws/codebuild/" + this.this$0.$settings.getSynnefoOptions().projectName()).status(LogsConfigStatusType.ENABLED);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$settings = synnefoProperties;
            }
        }).build();
        this.codeBuild.createProject(createRequest2);
    }

    private final List<ScheduledJob> startBuilds(Job job, SynnefoProperties settings, String sourceLocation) throws ExecutionException, InterruptedException {
        ArrayList<ScheduledJob> ids = new ArrayList<ScheduledJob>();
        for (SynnefoRunnerInfo info : job.getRunnerInfos()) {
            Path path = Paths.get(job.getJarPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(job.jarPath)");
            String buildSpec = this.generateBuildspecForFeature(((Object)path.getFileName()).toString(), info.getCucumberFeatureLocation(), info.getRuntimeOptions());
            StartBuildRequest buildStartRequest2 = (StartBuildRequest)StartBuildRequest.builder().projectName(settings.getSynnefoOptions().projectName()).buildspecOverride(buildSpec).imageOverride(settings.getSynnefoOptions().image()).computeTypeOverride(settings.getSynnefoOptions().computeType()).artifactsOverride((Consumer)new Consumer<ProjectArtifacts.Builder>(settings){
                final /* synthetic */ SynnefoProperties $settings;

                public final void accept(ProjectArtifacts.Builder a) {
                    a.type(ArtifactsType.S3).path(this.$settings.getSynnefoOptions().bucketOutputFolder()).name(this.$settings.getSynnefoOptions().outputFileName()).namespaceType("BUILD_ID").packaging("ZIP").location(this.$settings.getSynnefoOptions().bucketName());
                }
                {
                    this.$settings = synnefoProperties;
                }
            }).sourceLocationOverride(settings.getSynnefoOptions().bucketName() + "/" + sourceLocation).build();
            StartBuildResponse startBuildResponse = this.codeBuild.startBuild(buildStartRequest2);
            String buildId = startBuildResponse.build().id();
            Description junitDescription = Description.createTestDescription((String)info.getCucumberFeatureLocation(), (String)info.getCucumberFeatureLocation(), (Annotation[])new Annotation[0]);
            job.getNotifier().fireTestStarted(junitDescription);
            String string = buildId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildId");
            Description description = junitDescription;
            Intrinsics.checkExpressionValueIsNotNull((Object)description, (String)"junitDescription");
            ids.add(new ScheduledJob(job, string, info, description));
        }
        return ids;
    }

    private final void multipartUploadFile(@NotNull S3Client $receiver, String bucket, String key, String filePath, int partSizeMb) {
        CreateMultipartUploadRequest createUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().key(key).bucket(bucket).build();
        File file = new File(filePath);
        long contentLength = file.length();
        long partSize = (long)(partSizeMb * 1024) * 1024L;
        ArrayList<Object> partETags = new ArrayList<Object>();
        CreateMultipartUploadResponse response = $receiver.createMultipartUpload(createUploadRequest);
        System.out.println(response.uploadId());
        FileInputStream stream = new FileInputStream(file);
        long filePosition = 0L;
        int i = 1;
        while (filePosition < contentLength) {
            partSize = Math.min(partSize, contentLength - filePosition);
            UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(bucket).key(key).uploadId(response.uploadId()).partNumber(Integer.valueOf(i)).build();
            RequestBody data = RequestBody.fromInputStream((InputStream)stream, (long)partSize);
            String etag = this.s3.uploadPart(uploadRequest, data).eTag();
            partETags.add(CompletedPart.builder().partNumber(Integer.valueOf(i)).eTag(etag).build());
            filePosition += partSize;
            ++i;
        }
        stream.close();
        CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts((Collection)partETags).build();
        CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucket).key(key).uploadId(response.uploadId()).multipartUpload(completedMultipartUpload).build();
        this.s3.completeMultipartUpload(completeMultipartUploadRequest);
    }

    private final <E> List<E> dequeueUpTo(@NotNull List<E> $receiver, int limit) {
        int from = Math.max(0, $receiver.size() - limit);
        int to = Math.min($receiver.size(), from + limit);
        return $receiver.subList(from, to);
    }

    private final void appendWithEscaping(@NotNull StringBuilder $receiver, String s) {
        if (StringsKt.contains$default((CharSequence)s, (char)' ', (boolean)false, (int)2, null)) {
            $receiver.append('\"' + s + "\" ");
        } else {
            $receiver.append(s + ' ');
        }
    }

    private final void unzip(InputStream fileZip, String dest) {
        File destDir = new File(dest);
        destDir.mkdirs();
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(fileZip);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = this.newFile(destDir, zipEntry);
            FileOutputStream fos = new FileOutputStream(newFile);
            int len = 0;
            len = zis.read(buffer);
            while (len > 0) {
                fos.write(buffer, 0, len);
                len = zis.read(buffer);
            }
            fos.close();
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private final File newFile(File destinationDir, ZipEntry zipEntry) {
        String destFilePath;
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String string = destFilePath = destFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"destFilePath");
        if (!StringsKt.startsWith$default((String)string, (String)(destDirPath + File.separator), (boolean)false, (int)2, null)) {
            throw (Throwable)new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public AmazonCodeBuildScheduler(@NotNull SynnefoProperties settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.settings = settings;
        Object object = S3Client.builder().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"S3Client.builder().build()");
        this.s3 = (S3Client)object;
        Object object2 = CodeBuildClient.builder().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"CodeBuildClient.builder().build()");
        this.codeBuild = (CodeBuildClient)object2;
        this.buildSpecTemplate = "version: 0.2\n\nphases:\n  pre_build:\n    commands:\n      - echo Build started on `date`\n  build:\n    commands:\n      - mkdir result-artifacts\n      - cd result-artifacts\n      - %s\n      - ls\n  post_build:\n    commands:\n      - echo Build completed on `date`\nartifacts:\n  files:\n    - 'result-artifacts/**/*'\n  discard-paths: yes";
    }

    public static final /* synthetic */ void access$appendWithEscaping(AmazonCodeBuildScheduler $this, StringBuilder $receiver, String s) {
        $this.appendWithEscaping($receiver, s);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$Job;", "", "runnerInfos", "", "Lalbelli/junit/synnefo/runtime/SynnefoRunnerInfo;", "jarPath", "", "featurePaths", "notifier", "Lorg/junit/runner/notification/RunNotifier;", "(Ljava/util/List;Ljava/lang/String;Ljava/util/List;Lorg/junit/runner/notification/RunNotifier;)V", "getFeaturePaths", "()Ljava/util/List;", "getJarPath", "()Ljava/lang/String;", "getNotifier", "()Lorg/junit/runner/notification/RunNotifier;", "getRunnerInfos", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "junit.synnefo"})
    public static final class Job {
        @NotNull
        private final List<SynnefoRunnerInfo> runnerInfos;
        @NotNull
        private final String jarPath;
        @NotNull
        private final List<String> featurePaths;
        @NotNull
        private final RunNotifier notifier;

        @NotNull
        public final List<SynnefoRunnerInfo> getRunnerInfos() {
            return this.runnerInfos;
        }

        @NotNull
        public final String getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final List<String> getFeaturePaths() {
            return this.featurePaths;
        }

        @NotNull
        public final RunNotifier getNotifier() {
            return this.notifier;
        }

        public Job(@NotNull List<SynnefoRunnerInfo> runnerInfos, @NotNull String jarPath, @NotNull List<String> featurePaths, @NotNull RunNotifier notifier) {
            Intrinsics.checkParameterIsNotNull(runnerInfos, (String)"runnerInfos");
            Intrinsics.checkParameterIsNotNull((Object)jarPath, (String)"jarPath");
            Intrinsics.checkParameterIsNotNull(featurePaths, (String)"featurePaths");
            Intrinsics.checkParameterIsNotNull((Object)notifier, (String)"notifier");
            this.runnerInfos = runnerInfos;
            this.jarPath = jarPath;
            this.featurePaths = featurePaths;
            this.notifier = notifier;
        }

        @NotNull
        public final List<SynnefoRunnerInfo> component1() {
            return this.runnerInfos;
        }

        @NotNull
        public final String component2() {
            return this.jarPath;
        }

        @NotNull
        public final List<String> component3() {
            return this.featurePaths;
        }

        @NotNull
        public final RunNotifier component4() {
            return this.notifier;
        }

        @NotNull
        public final Job copy(@NotNull List<SynnefoRunnerInfo> runnerInfos, @NotNull String jarPath, @NotNull List<String> featurePaths, @NotNull RunNotifier notifier) {
            Intrinsics.checkParameterIsNotNull(runnerInfos, (String)"runnerInfos");
            Intrinsics.checkParameterIsNotNull((Object)jarPath, (String)"jarPath");
            Intrinsics.checkParameterIsNotNull(featurePaths, (String)"featurePaths");
            Intrinsics.checkParameterIsNotNull((Object)notifier, (String)"notifier");
            return new Job(runnerInfos, jarPath, featurePaths, notifier);
        }

        @NotNull
        public static /* synthetic */ Job copy$default(Job job, List list, String string, List list2, RunNotifier runNotifier, int n, Object object) {
            if ((n & 1) != 0) {
                list = job.runnerInfos;
            }
            if ((n & 2) != 0) {
                string = job.jarPath;
            }
            if ((n & 4) != 0) {
                list2 = job.featurePaths;
            }
            if ((n & 8) != 0) {
                runNotifier = job.notifier;
            }
            return job.copy(list, string, list2, runNotifier);
        }

        @NotNull
        public String toString() {
            return "Job(runnerInfos=" + this.runnerInfos + ", jarPath=" + this.jarPath + ", featurePaths=" + this.featurePaths + ", notifier=" + this.notifier + ")";
        }

        public int hashCode() {
            List<SynnefoRunnerInfo> list = this.runnerInfos;
            String string = this.jarPath;
            List<String> list2 = this.featurePaths;
            RunNotifier runNotifier = this.notifier;
            return (((list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (runNotifier != null ? runNotifier.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Job)) break block3;
                    Job job = (Job)object;
                    if (!Intrinsics.areEqual(this.runnerInfos, job.runnerInfos) || !Intrinsics.areEqual((Object)this.jarPath, (Object)job.jarPath) || !Intrinsics.areEqual(this.featurePaths, job.featurePaths) || !Intrinsics.areEqual((Object)this.notifier, (Object)job.notifier)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$ScheduledJob;", "", "originalJob", "Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$Job;", "buildId", "", "info", "Lalbelli/junit/synnefo/runtime/SynnefoRunnerInfo;", "junitDescription", "Lorg/junit/runner/Description;", "(Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$Job;Ljava/lang/String;Lalbelli/junit/synnefo/runtime/SynnefoRunnerInfo;Lorg/junit/runner/Description;)V", "getBuildId", "()Ljava/lang/String;", "getInfo", "()Lalbelli/junit/synnefo/runtime/SynnefoRunnerInfo;", "getJunitDescription", "()Lorg/junit/runner/Description;", "getOriginalJob", "()Lalbelli/junit/synnefo/runtime/AmazonCodeBuildScheduler$Job;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "junit.synnefo"})
    public static final class ScheduledJob {
        @NotNull
        private final Job originalJob;
        @NotNull
        private final String buildId;
        @NotNull
        private final SynnefoRunnerInfo info;
        @NotNull
        private final Description junitDescription;

        @NotNull
        public final Job getOriginalJob() {
            return this.originalJob;
        }

        @NotNull
        public final String getBuildId() {
            return this.buildId;
        }

        @NotNull
        public final SynnefoRunnerInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final Description getJunitDescription() {
            return this.junitDescription;
        }

        public ScheduledJob(@NotNull Job originalJob, @NotNull String buildId, @NotNull SynnefoRunnerInfo info, @NotNull Description junitDescription) {
            Intrinsics.checkParameterIsNotNull((Object)originalJob, (String)"originalJob");
            Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            Intrinsics.checkParameterIsNotNull((Object)junitDescription, (String)"junitDescription");
            this.originalJob = originalJob;
            this.buildId = buildId;
            this.info = info;
            this.junitDescription = junitDescription;
        }

        @NotNull
        public final Job component1() {
            return this.originalJob;
        }

        @NotNull
        public final String component2() {
            return this.buildId;
        }

        @NotNull
        public final SynnefoRunnerInfo component3() {
            return this.info;
        }

        @NotNull
        public final Description component4() {
            return this.junitDescription;
        }

        @NotNull
        public final ScheduledJob copy(@NotNull Job originalJob, @NotNull String buildId, @NotNull SynnefoRunnerInfo info, @NotNull Description junitDescription) {
            Intrinsics.checkParameterIsNotNull((Object)originalJob, (String)"originalJob");
            Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            Intrinsics.checkParameterIsNotNull((Object)junitDescription, (String)"junitDescription");
            return new ScheduledJob(originalJob, buildId, info, junitDescription);
        }

        @NotNull
        public static /* synthetic */ ScheduledJob copy$default(ScheduledJob scheduledJob, Job job, String string, SynnefoRunnerInfo synnefoRunnerInfo, Description description, int n, Object object) {
            if ((n & 1) != 0) {
                job = scheduledJob.originalJob;
            }
            if ((n & 2) != 0) {
                string = scheduledJob.buildId;
            }
            if ((n & 4) != 0) {
                synnefoRunnerInfo = scheduledJob.info;
            }
            if ((n & 8) != 0) {
                description = scheduledJob.junitDescription;
            }
            return scheduledJob.copy(job, string, synnefoRunnerInfo, description);
        }

        @NotNull
        public String toString() {
            return "ScheduledJob(originalJob=" + this.originalJob + ", buildId=" + this.buildId + ", info=" + this.info + ", junitDescription=" + this.junitDescription + ")";
        }

        public int hashCode() {
            Job job = this.originalJob;
            String string = this.buildId;
            SynnefoRunnerInfo synnefoRunnerInfo = this.info;
            Description description = this.junitDescription;
            return (((job != null ? ((Object)job).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (synnefoRunnerInfo != null ? synnefoRunnerInfo.hashCode() : 0)) * 31 + (description != null ? description.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ScheduledJob)) break block3;
                    ScheduledJob scheduledJob = (ScheduledJob)object;
                    if (!Intrinsics.areEqual((Object)this.originalJob, (Object)scheduledJob.originalJob) || !Intrinsics.areEqual((Object)this.buildId, (Object)scheduledJob.buildId) || !Intrinsics.areEqual((Object)this.info, (Object)scheduledJob.info) || !Intrinsics.areEqual((Object)this.junitDescription, (Object)scheduledJob.junitDescription)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

