/*
 * Decompiled with CFR 0.152.
 */
package alex.jenkins.plugins;

import alex.jenkins.plugins.FileSystemListParameterDefinition;
import alex.jenkins.plugins.FileSystemListParameterValue;
import alex.jenkins.plugins.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FileSystemListParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 9032072543915872650L;
    private static final Logger LOGGER = Logger.getLogger(FileSystemListParameterDefinition.class.getName());
    private String path;
    private String selectedType;
    private boolean sortByLastModified;
    private boolean sortReverseOrder;
    private FsObjectTypes selectedEnumType;
    private String regexIncludePattern;
    private String regexExcludePattern;
    private String value;
    private Formatter formatter;
    SortedMap<String, Long> map;

    @DataBoundConstructor
    public FileSystemListParameterDefinition(String name, String description, String path, String selectedType, String regexIncludePattern, String regexExcludePattern, boolean sortByLastModified, boolean sortReverseOrder) {
        super(name, description);
        this.path = path;
        this.selectedType = selectedType;
        this.selectedEnumType = FsObjectTypes.valueOf((String)selectedType);
        this.sortByLastModified = sortByLastModified;
        this.sortReverseOrder = sortReverseOrder;
        this.regexIncludePattern = regexIncludePattern;
        this.regexExcludePattern = regexExcludePattern;
        this.formatter = new Formatter();
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            strValue = StringUtils.join((Iterator)jsonValues.iterator(), (char)',');
        }
        return new FileSystemListParameterValue(this.getName(), strValue);
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultValue = "";
        try {
            defaultValue = this.getEffectiveDefaultValue();
        }
        catch (IOException e) {
            LOGGER.warning(this.formatter.format(Messages.FileSystemListParameterDefinition_SymlinkDetectionError(), defaultValue).toString());
        }
        if (!StringUtils.isBlank((String)defaultValue)) {
            return new FileSystemListParameterValue(this.getName(), defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String getEffectiveDefaultValue() throws IOException {
        List defaultList = this.getFsObjectsList();
        String defaultValue = (String)defaultList.get(0);
        return defaultValue;
    }

    public List<String> getFsObjectsList() throws IOException {
        this.map = new TreeMap();
        File rootDir = new File(this.path);
        switch (1.$SwitchMap$alex$jenkins$plugins$FileSystemListParameterDefinition$FsObjectTypes[this.getSelectedEnumType().ordinal()]) {
            case 1: {
                this.createSymlinkMap(rootDir);
                break;
            }
            case 2: {
                this.createDirectoryMap(rootDir);
                break;
            }
            case 3: {
                this.createFileMap(rootDir);
                break;
            }
            default: {
                this.createAllObjectsMap(rootDir);
            }
        }
        return this.sortList();
    }

    List<String> sortList() {
        ArrayList<String> list;
        if (this.map.isEmpty()) {
            list = new ArrayList();
            String msg = this.formatter.format(Messages.FileSystemListParameterDefinition_NoObjectsFoundAtPath(), this.getSelectedEnumType(), this.getRegexIncludePattern(), this.getRegexExcludePattern(), this.getPath()).toString();
            LOGGER.warning(msg);
            list.add(msg);
        } else {
            if (this.isSortByLastModified()) {
                list = this.createTimeSortedList();
            } else {
                list = new ArrayList();
                list.addAll(this.map.keySet());
            }
            if (this.isSortReverseOrder()) {
                Collections.reverse(list);
            }
        }
        return list;
    }

    List<String> createTimeSortedList() {
        ArrayList<String> list = new ArrayList<String>();
        Collection valuesC = this.map.values();
        ArrayList sortList = new ArrayList(valuesC);
        Collections.sort(sortList);
        for (Long value : sortList) {
            if (!this.map.containsValue(value)) continue;
            for (String key : this.map.keySet()) {
                if (value != this.map.get(key)) continue;
                list.add(key);
            }
        }
        return list;
    }

    private boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    private boolean isPatternMatching(String name) {
        if (this.getRegexIncludePattern().equals("") && this.getRegexExcludePattern().equals("")) {
            return true;
        }
        if (!this.getRegexIncludePattern().equals("") && this.getRegexExcludePattern().equals("")) {
            return name.matches(this.getRegexIncludePattern());
        }
        if (this.getRegexIncludePattern().equals("") && !this.getRegexExcludePattern().equals("")) {
            return !name.matches(this.getRegexExcludePattern());
        }
        return name.matches(this.getRegexIncludePattern()) && !name.matches(this.getRegexExcludePattern());
    }

    private void createSymlinkMap(File rootDir) throws IOException {
        for (File file : rootDir.listFiles()) {
            if (file.isHidden() || !this.isSymlink(file) || !this.isPatternMatching(file.getName())) continue;
            this.map.put(file.getName(), file.lastModified());
            LOGGER.finest("add " + file);
        }
    }

    private void createDirectoryMap(File rootDir) throws IOException {
        for (File file : rootDir.listFiles()) {
            if (file.isHidden() || !file.isDirectory() || this.isSymlink(file) || !this.isPatternMatching(file.getName())) continue;
            this.map.put(file.getName(), file.lastModified());
            LOGGER.finest("add " + file);
        }
    }

    private void createFileMap(File rootDir) throws IOException {
        for (File file : rootDir.listFiles()) {
            if (file.isHidden() || !file.isFile() || this.isSymlink(file) || !this.isPatternMatching(file.getName())) continue;
            this.map.put(file.getName(), file.lastModified());
            LOGGER.finest("add " + file);
        }
    }

    private void createAllObjectsMap(File rootDir) {
        for (File file : rootDir.listFiles()) {
            if (file.isHidden() || !this.isPatternMatching(file.getName())) continue;
            this.map.put(file.getName(), file.lastModified());
            LOGGER.finest("add " + file);
        }
    }

    public List<String> getJellyFsObjectTypes() {
        ArrayList<String> list = new ArrayList<String>();
        String selected = this.getSelectedType();
        LOGGER.finest("# selectedType=" + selected);
        if (selected.equals("")) {
            for (FsObjectTypes type : FsObjectTypes.values()) {
                String string = type.toString();
                LOGGER.finest("# add " + string);
                list.add(string);
            }
        } else {
            LOGGER.finest("# add " + selected);
            list.add(selected);
            for (FsObjectTypes type : FsObjectTypes.values()) {
                String string = type.toString();
                if (selected.equals(string)) continue;
                LOGGER.finest("# add " + string);
                list.add(string);
            }
        }
        return list;
    }

    public String getPath() {
        return this.path;
    }

    public String getSelectedType() {
        return this.selectedType;
    }

    public boolean isSortByLastModified() {
        return this.sortByLastModified;
    }

    public boolean isSortReverseOrder() {
        return this.sortReverseOrder;
    }

    public FsObjectTypes getSelectedEnumType() {
        return this.selectedEnumType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRegexIncludePattern() {
        return this.regexIncludePattern;
    }

    public String getRegexExcludePattern() {
        return this.regexExcludePattern;
    }
}

