/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.cache.examples.dbversioncache;

import ae.teletronics.cache.ChangingValueAndLevelMultiCache;
import ae.teletronics.cache.Pair;
import ae.teletronics.cache.examples.dbversioncache.KeyValueOptimisticLockingDBWithPluggableCache;
import ae.teletronics.cache.examples.dbversioncache.StringValueContainer;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;

public class StringStringOptimisticLockingDBWithKeyStartsWithCache
extends KeyValueOptimisticLockingDBWithPluggableCache<String, String, StringValueContainer> {
    public StringStringOptimisticLockingDBWithKeyStartsWithCache(int cacheSize, int[] levelSplitAfter) {
        this.initialize(new KeyStartsWithCache(cacheSize, levelSplitAfter));
    }

    @Override
    protected Object getSynchObject(String key) {
        return null;
    }

    @Override
    protected void putImpl(String key, KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
        ((KeyStartsWithCache)this.cache).put(key, storeRequest, true);
    }

    public Map<String, StringValueContainer> getAllWithKeyStartingWith(final String keyStart) {
        CacheValue cacheValue = ((KeyStartsWithCache)this.cache).innerCache.modify(keyStart, new Supplier<CacheValue>(){

            public CacheValue get() {
                CacheValue newCacheValue = new CacheValue();
                newCacheValue.getKeySuffixToValueMap().putAll(StringStringOptimisticLockingDBWithKeyStartsWithCache.this.getAllFromStore(keyStart, null));
                newCacheValue.setComplete();
                return newCacheValue;
            }
        }, new Function<CacheValue, CacheValue>(){

            public CacheValue apply(CacheValue input) {
                if (!input.isComplete()) {
                    input.getKeySuffixToValueMap().putAll(StringStringOptimisticLockingDBWithKeyStartsWithCache.this.getAllFromStore(keyStart, input.getKeySuffixToValueMap()));
                    input.setComplete();
                }
                return input;
            }
        }, true);
        return this.cloneMapStringStringValueContainer(cacheValue.getKeySuffixToValueMap());
    }

    private Map<String, StringValueContainer> getAllFromStore(String keyStart, Map<String, StringValueContainer> dontGet) {
        HashMap<String, StringValueContainer> result = new HashMap<String, StringValueContainer>();
        for (Map.Entry entry : this.store.entrySet()) {
            Pair splittedEntryKey = ((KeyStartsWithCache)this.cache).splitKey((String)entry.getKey());
            if (!keyStart.equals(splittedEntryKey._1) || dontGet != null && dontGet.containsKey(splittedEntryKey._2)) continue;
            result.put((String)splittedEntryKey._2, (StringValueContainer)entry.getValue());
        }
        return result;
    }

    private Map<String, StringValueContainer> cloneMapStringStringValueContainer(Map<String, StringValueContainer> toBeCloned) {
        if (toBeCloned == null) {
            return null;
        }
        HashMap<String, StringValueContainer> clone = new HashMap<String, StringValueContainer>(toBeCloned.size());
        for (Map.Entry<String, StringValueContainer> entry : toBeCloned.entrySet()) {
            clone.put(new String(entry.getKey()), entry.getValue().clone());
        }
        return clone;
    }

    public class KeyStartsWithCache
    implements KeyValueOptimisticLockingDBWithPluggableCache.Cache<String, String, StringValueContainer> {
        private static final String SPLIT = "!";
        private final ChangingValueAndLevelMultiCache<String, CacheValue> innerCache;

        private KeyStartsWithCache(int cachesSize, int[] levelSplitAfter) {
            Cache innerInnerCache = CacheBuilder.newBuilder().maximumSize((long)cachesSize).build();
            ChangingValueAndLevelMultiCache.Builder innerCacheBuilder = ChangingValueAndLevelMultiCache.builder();
            ((ChangingValueAndLevelMultiCache.Builder)((ChangingValueAndLevelMultiCache.Builder)innerCacheBuilder.cache(innerInnerCache)).defaultModifier((Function)new Function<CacheValue, CacheValue>(){

                public CacheValue apply(CacheValue input) {
                    return input;
                }
            })).levelCalculator(new ChangingValueAndLevelMultiCache.BiFunction<String, CacheValue, Integer>(){

                @Override
                public Integer apply(String key, CacheValue cacheValue) {
                    return cacheValue.getKeySuffixToValueMap().size();
                }
            });
            int currentLevelIntervalStart = 0;
            for (int currentLevelIntervalEnd : levelSplitAfter) {
                innerInnerCache = CacheBuilder.newBuilder().maximumSize((long)cachesSize).build();
                innerCacheBuilder.addCache(innerInnerCache, currentLevelIntervalStart, currentLevelIntervalEnd, "Inner Cache " + currentLevelIntervalStart + "-" + currentLevelIntervalEnd + " size");
                currentLevelIntervalStart = currentLevelIntervalEnd + 1;
            }
            this.innerCache = innerCacheBuilder.build();
        }

        @Override
        public void put(String key, KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
            this.put(key, storeRequest, false);
        }

        protected void put(final String key, final KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest, final boolean putInStore) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
            try {
                final Pair<String, String> splittedKey = this.splitKey(key);
                this.innerCache.modify((String)splittedKey._1, new Supplier<CacheValue>(){

                    public CacheValue get() {
                        return new CacheValue();
                    }
                }, new Function<CacheValue, CacheValue>(){

                    public CacheValue apply(CacheValue input) {
                        try {
                            StringValueContainer newValue = (StringValueContainer)StringStringOptimisticLockingDBWithKeyStartsWithCache.this.versionCheck(key, storeRequest);
                            if (putInStore) {
                                StringStringOptimisticLockingDBWithKeyStartsWithCache.this.store.put(key, newValue);
                            }
                            input.getKeySuffixToValueMap().put((String)splittedKey._2, newValue);
                            return input;
                        }
                        catch (Exception e) {
                            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                        }
                    }
                }, true);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException)cause;
                }
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException)cause;
                }
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException)cause;
                }
                throw e;
            }
        }

        @Override
        public StringValueContainer get(String key) {
            Pair<String, String> splittedKey = this.splitKey(key);
            CacheValue cacheValue = (CacheValue)this.innerCache.getIfPresent((String)splittedKey._1);
            if (cacheValue != null) {
                return cacheValue.getKeySuffixToValueMap().get(splittedKey._2);
            }
            return null;
        }

        @Override
        public Long getVersion(String key) {
            StringValueContainer valueContainer = this.get(key);
            return valueContainer != null ? valueContainer.getVersion() : null;
        }

        private Pair<String, String> splitKey(String key) {
            int splitIndex = key.indexOf(SPLIT);
            if (splitIndex < 0) {
                return new Pair<String, Object>(key, null);
            }
            return new Pair<String, String>(key.substring(0, splitIndex), key.substring(splitIndex + SPLIT.length()));
        }
    }

    public static class CacheValue {
        private boolean complete = false;
        private Map<String, StringValueContainer> keySuffixToValueMap = new HashMap<String, StringValueContainer>();

        public boolean isComplete() {
            return this.complete;
        }

        public void setComplete() {
            this.complete = true;
        }

        public Map<String, StringValueContainer> getKeySuffixToValueMap() {
            return this.keySuffixToValueMap;
        }
    }
}

