/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.cache.examples.dbversioncache;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class KeyValueOptimisticLockingDBWithPluggableCache<STOREKEY, STOREVALUE, STOREVALUECONTAINER extends ValueContainer<STOREVALUE>> {
    protected ConcurrentMap<STOREKEY, STOREVALUECONTAINER> store = new ConcurrentHashMap<STOREKEY, STOREVALUECONTAINER>();
    protected Cache<STOREKEY, STOREVALUE, STOREVALUECONTAINER> cache;
    private final Interner<Integer> keyInterner = Interners.newWeakInterner();

    public void initialize(Cache<STOREKEY, STOREVALUE, STOREVALUECONTAINER> cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(STOREKEY key, StoreRequest<STOREVALUE, STOREVALUECONTAINER> storeRequest) throws AlreadyExistsException, DoesNotAlreadyExistException, VersionConflictException {
        Object synchObject = this.getSynchObject(key);
        if (synchObject != null) {
            Object object = synchObject;
            synchronized (object) {
                this.putImpl(key, storeRequest);
            }
        } else {
            this.putImpl(key, storeRequest);
        }
    }

    protected Object getSynchObject(STOREKEY key) {
        return this.keyInterner.intern((Object)key.hashCode());
    }

    protected void putImpl(STOREKEY key, StoreRequest<STOREVALUE, STOREVALUECONTAINER> storeRequest) throws AlreadyExistsException, DoesNotAlreadyExistException, VersionConflictException {
        STOREVALUECONTAINER newValue = this.versionCheck(key, storeRequest);
        this.store.put(key, newValue);
        this.cache.put(key, storeRequest);
    }

    protected final STOREVALUECONTAINER versionCheck(STOREKEY key, StoreRequest<STOREVALUE, STOREVALUECONTAINER> storeRequest) throws AlreadyExistsException, DoesNotAlreadyExistException, VersionConflictException {
        Long currentVersion = this.getCurrentVersion(key);
        if (storeRequest.getRequestedOperation() == StoreRequest.Operation.NEW && currentVersion != null) {
            throw new AlreadyExistsException();
        }
        if (storeRequest.getRequestedOperation() == StoreRequest.Operation.UPDATE) {
            if (currentVersion == null) {
                throw new DoesNotAlreadyExistException();
            }
            if (!storeRequest.getValueContainer().getVersion().equals(currentVersion)) {
                throw new VersionConflictException();
            }
        }
        STOREVALUECONTAINER newValue = storeRequest.getValueContainer();
        newValue.setVersion(storeRequest.getRequestedOperation() == StoreRequest.Operation.NEW ? 0L : newValue.getVersion() + 1L);
        return newValue;
    }

    public STOREVALUECONTAINER get(STOREKEY key) {
        return this.get(key, true);
    }

    private STOREVALUECONTAINER get(STOREKEY key, boolean putInCache) {
        Object returnValue;
        STOREVALUECONTAINER cacheValue = this.cache.get(key);
        if (cacheValue != null) {
            returnValue = cacheValue;
        } else {
            final ValueContainer storeValue = (ValueContainer)this.store.get(key);
            if (storeValue != null && putInCache) {
                try {
                    this.cache.put(key, new StoreRequest<STOREVALUE, STOREVALUECONTAINER>(){

                        @Override
                        public STOREVALUECONTAINER getValueContainer() {
                            return storeValue;
                        }

                        @Override
                        public StoreRequest.Operation getRequestedOperation() {
                            return StoreRequest.Operation.NEW;
                        }
                    });
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            returnValue = storeValue;
        }
        ValueContainer clone = returnValue != null ? returnValue.clone() : null;
        return (STOREVALUECONTAINER)clone;
    }

    private Long getCurrentVersion(STOREKEY key) {
        Long currentVersion = this.cache.getVersion(key);
        if (currentVersion != null) {
            return currentVersion;
        }
        STOREVALUECONTAINER currentValue = this.get(key, false);
        return currentValue != null ? currentValue.getVersion() : null;
    }

    public static interface Cache<STOREKEY, STOREVALUE, STOREVALUECONTAINER extends ValueContainer<STOREVALUE>> {
        public void put(STOREKEY var1, StoreRequest<STOREVALUE, STOREVALUECONTAINER> var2) throws AlreadyExistsException, DoesNotAlreadyExistException, VersionConflictException;

        public STOREVALUECONTAINER get(STOREKEY var1);

        public Long getVersion(STOREKEY var1);
    }

    public static interface StoreRequest<VALUE, VALUECONTAINER extends ValueContainer<VALUE>> {
        public VALUECONTAINER getValueContainer();

        public Operation getRequestedOperation();

        public static enum Operation {
            NEW,
            UPDATE;

        }
    }

    public static interface ValueContainer<VALUE>
    extends Cloneable {
        public void setVersion(Long var1);

        public Long getVersion();

        public VALUE getValue();

        public ValueContainer<VALUE> clone();
    }

    public static class VersionConflictException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class DoesNotAlreadyExistException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class AlreadyExistsException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

