/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.cache;

import ae.teletronics.cache.ChangingValueCache;
import ae.teletronics.cache.Pair;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ChangingValueAndLevelMultiCache<K, V>
extends ChangingValueCache<K, V> {
    protected Map<Interval, Cache<K, V>> caches = new HashMap<Interval, Cache<K, V>>();
    protected Map<Cache<K, V>, String> names = new HashMap<Cache<K, V>, String>();
    protected BiFunction<K, V, Integer> levelCalculator;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V modifyImpl(K key, Supplier<V> newCreator, Function<V, V> modifier, boolean createIfNotExists, boolean supportRecursiveCalls) {
        Object value = this.alreadyWorkingOn.get();
        if (value != null) {
            Object newValue = (modifier != null ? modifier : this.defaultModifier).apply(value);
            if (newValue != value) {
                throw new RuntimeException("Modifier called modify with a modifier that replaced value object with another value object");
            }
        } else {
            Pair<Cache<K, V>, V> cacheAndValue = this.getCacheAndValueIfPresent(key);
            Cache oldCache = null;
            if (cacheAndValue == null) {
                if (createIfNotExists) {
                    value = (newCreator != null ? newCreator : this.defaultNewCreator).get();
                }
            } else {
                oldCache = (Cache)cacheAndValue._1;
                value = cacheAndValue._2;
            }
            if (value != null) {
                if (supportRecursiveCalls) {
                    this.alreadyWorkingOn.set(value);
                }
                try {
                    Object newValue = (modifier != null ? modifier : this.defaultModifier).apply(value);
                    if (newValue == null) {
                        if (oldCache != null) {
                            oldCache.invalidate(key);
                        }
                    } else {
                        Cache<K, V> newCache = this.cacheForLevel(this.levelCalculator.apply(key, newValue));
                        if (oldCache != newCache || newValue != value) {
                            if (oldCache != null && oldCache != newCache) {
                                oldCache.invalidate(key);
                            }
                            if (newCache != null) {
                                newCache.put(key, newValue);
                            }
                        }
                    }
                    value = newValue;
                }
                finally {
                    if (supportRecursiveCalls) {
                        this.alreadyWorkingOn.remove();
                    }
                }
            }
        }
        return (V)value;
    }

    @Override
    protected Collection<Cache<K, V>> getAllCaches() {
        Collection allCaches = super.getAllCaches();
        for (Cache<K, V> cache : this.caches.values()) {
            allCaches.add(cache);
        }
        return allCaches;
    }

    public Pair<Cache<K, V>, V> getCacheAndValueIfPresent(K key) {
        for (Cache<K, V> cache : this.getAllCaches()) {
            Object value = cache.getIfPresent(key);
            if (value == null) continue;
            return this.createCacheAndValuePair(cache, value);
        }
        return null;
    }

    protected Pair<Cache<K, V>, V> createCacheAndValuePair(Cache<K, V> cache, V value) {
        return new Pair<Cache<K, V>, V>(cache, value);
    }

    protected Cache<K, V> cacheForLevel(int level) {
        for (Map.Entry<Interval, Cache<K, V>> entry : this.caches.entrySet()) {
            if (!entry.getKey().belongsIn(level)) continue;
            return entry.getValue();
        }
        return this.cache;
    }

    public static class Interval {
        private int from;
        private int to;

        public Interval(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public boolean belongsIn(int value) {
            return value >= this.from && value <= this.to;
        }
    }

    public static class Builder<K, V>
    extends ChangingValueCache.Builder<K, V> {
        @Override
        protected ChangingValueAndLevelMultiCache<K, V> createInstance() {
            return new ChangingValueAndLevelMultiCache();
        }

        private ChangingValueAndLevelMultiCache<K, V> getInstance() {
            return (ChangingValueAndLevelMultiCache)this.instance;
        }

        @Override
        public Builder<K, V> defaultNewCreator(Supplier<V> newCreator) {
            return (Builder)super.defaultNewCreator(newCreator);
        }

        @Override
        public Builder<K, V> defaultModifier(Function<V, V> modifier) {
            return (Builder)super.defaultModifier(modifier);
        }

        @Override
        public Builder<K, V> cache(Cache<K, V> cache) {
            return (Builder)super.cache(cache);
        }

        public Builder<K, V> levelCalculator(BiFunction<K, V, Integer> levelCalculator) {
            this.getInstance().levelCalculator = levelCalculator;
            return this;
        }

        public Builder<K, V> addCache(Cache<K, V> cache, int levelFrom, int levelTo, String name) {
            this.getInstance().caches.put(new Interval(levelFrom, levelTo), cache);
            this.getInstance().names.put(cache, name);
            return this;
        }

        @Override
        public ChangingValueAndLevelMultiCache<K, V> build() {
            if (this.getInstance().levelCalculator == null) {
                throw new RuntimeException("No levelCalculator set");
            }
            return (ChangingValueAndLevelMultiCache)super.build();
        }
    }

    public static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }
}

