/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.cache.examples.dbversioncache;

import ae.teletronics.cache.ChangingValueCache;
import ae.teletronics.cache.examples.dbversioncache.KeyValueOptimisticLockingDBWithPluggableCache;
import ae.teletronics.cache.examples.dbversioncache.StringValueContainer;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

public class StringStringOptimisticLockingDBWithVersionCache
extends KeyValueOptimisticLockingDBWithPluggableCache<String, String, StringValueContainer> {
    public StringStringOptimisticLockingDBWithVersionCache(int cacheSize) {
        this.initialize(new VersionCache(cacheSize));
    }

    @Override
    protected Object getSynchObject(String key) {
        return null;
    }

    @Override
    protected void putImpl(String key, KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
        ((VersionCache)this.cache).put(key, storeRequest, true);
    }

    private class VersionCache
    implements KeyValueOptimisticLockingDBWithPluggableCache.Cache<String, String, StringValueContainer> {
        private final ChangingValueCache<String, Long> innerCache;

        private VersionCache(int cacheSize) {
            Cache innerInnerCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
            ChangingValueCache.Builder innerCacheBuilder = ChangingValueCache.builder();
            this.innerCache = innerCacheBuilder.cache(innerInnerCache).defaultModifier(new Function<Long, Long>(){

                public Long apply(Long input) {
                    return input;
                }
            }).build();
        }

        @Override
        public void put(String key, KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
            this.put(key, storeRequest, false);
        }

        protected void put(final String key, final KeyValueOptimisticLockingDBWithPluggableCache.StoreRequest<String, StringValueContainer> storeRequest, final boolean putInStore) throws KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException, KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException, KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException {
            try {
                this.innerCache.modify(key, new Supplier<Long>(){

                    public Long get() {
                        return -1L;
                    }
                }, new Function<Long, Long>(){

                    public Long apply(Long input) {
                        try {
                            StringValueContainer newValue = (StringValueContainer)StringStringOptimisticLockingDBWithVersionCache.this.versionCheck(key, storeRequest);
                            if (putInStore) {
                                StringStringOptimisticLockingDBWithVersionCache.this.store.put(key, newValue);
                            }
                            return newValue.getVersion();
                        }
                        catch (Exception e) {
                            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                        }
                    }
                }, true);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.AlreadyExistsException)cause;
                }
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.DoesNotAlreadyExistException)cause;
                }
                if (cause instanceof KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException) {
                    throw (KeyValueOptimisticLockingDBWithPluggableCache.VersionConflictException)cause;
                }
                throw e;
            }
        }

        @Override
        public StringValueContainer get(String key) {
            return null;
        }

        @Override
        public Long getVersion(String key) {
            return this.innerCache.getIfPresent(key);
        }
    }
}

