/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.cache;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ChangingValueCache<K, V> {
    protected Supplier<V> defaultNewCreator;
    protected Function<V, V> defaultModifier;
    protected Cache<K, V> cache;
    protected final Interner<Integer> newOrMovingCacheEntryInterner;
    protected ThreadLocal<V> alreadyWorkingOn = new ThreadLocal();
    private NoModificationModifier noModificationModifier = new NoModificationModifier();

    protected ChangingValueCache() {
        this.newOrMovingCacheEntryInterner = Interners.newWeakInterner();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public final V modify(K key, boolean createIfNotExists) {
        return this.modify(key, null, null, createIfNotExists);
    }

    public final V modify(K key, Function<V, V> modifier, boolean createIfNotExists) {
        return this.modify(key, null, modifier, createIfNotExists);
    }

    public final V modify(K key, Supplier<V> newCreator, boolean createIfNotExists) {
        return this.modify(key, newCreator, null, createIfNotExists);
    }

    public final V modify(K key, Supplier<V> newCreator, Function<V, V> modifier, boolean createIfNotExists) {
        return this.modify(key, newCreator, modifier, createIfNotExists, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V modify(K key, Supplier<V> newCreator, Function<V, V> modifier, boolean createIfNotExists, boolean supportRecursiveCalls) {
        Integer n = (Integer)this.newOrMovingCacheEntryInterner.intern((Object)key.hashCode());
        synchronized (n) {
            return this.modifyImpl(key, newCreator, modifier, createIfNotExists, supportRecursiveCalls);
        }
    }

    public final void modifyAll(Predicate<K> keyPredicate, Predicate<V> valuePredicate) {
        this.modifyAll(keyPredicate, valuePredicate, null);
    }

    public final void modifyAll(Predicate<K> keyPredicate, Predicate<V> valuePredicate, Function<V, V> modifier) {
        this.modifyAll(keyPredicate, valuePredicate, modifier, false);
    }

    public final void modifyAll(Predicate<K> keyPredicate, Predicate<V> valuePredicate, Function<V, V> modifier, boolean supportRecursiveCalls) {
        for (Cache<K, V> cache : this.getAllCaches()) {
            for (Map.Entry entry : cache.asMap().entrySet()) {
                if (keyPredicate != null && !keyPredicate.apply(entry.getKey()) || valuePredicate != null && !valuePredicate.apply(entry.getValue())) continue;
                this.modify(entry.getKey(), null, modifier, false, supportRecursiveCalls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V modifyImpl(K key, Supplier<V> newCreator, Function<V, V> modifier, boolean createIfNotExists, boolean supportRecursiveCalls) {
        Object value = this.alreadyWorkingOn.get();
        if (value != null) {
            Object newValue = (modifier != null ? modifier : this.defaultModifier).apply(value);
            if (newValue != value) {
                throw new RuntimeException("Modifier called modify with a modifier that replaced value object with another value object");
            }
        } else {
            value = this.getIfPresent(key);
            boolean created = false;
            if (value == null && createIfNotExists) {
                value = (newCreator != null ? newCreator : this.defaultNewCreator).get();
                created = true;
            }
            if (value != null) {
                if (supportRecursiveCalls) {
                    this.alreadyWorkingOn.set(value);
                }
                try {
                    Object newValue = (modifier != null ? modifier : this.defaultModifier).apply(value);
                    if (newValue == null) {
                        this.cache.invalidate(key);
                    } else if (created || newValue != value) {
                        this.cache.put(key, newValue);
                    }
                    value = newValue;
                }
                finally {
                    if (supportRecursiveCalls) {
                        this.alreadyWorkingOn.remove();
                    }
                }
            }
        }
        return value;
    }

    protected Collection<Cache<K, V>> getAllCaches() {
        ArrayList<Cache<K, V>> allCaches = new ArrayList<Cache<K, V>>();
        if (this.cache != null) {
            allCaches.add(this.cache);
        }
        return allCaches;
    }

    public V getIfPresent(K key) {
        for (Cache<K, V> cache : this.getAllCaches()) {
            Object value = cache.getIfPresent(key);
            if (value == null) continue;
            return (V)value;
        }
        return null;
    }

    public long size() {
        long size = 0L;
        for (Cache<K, V> cache : this.getAllCaches()) {
            size += cache.size();
        }
        return size;
    }

    public V getAddIfNotPresent(K key) {
        return this.getAddIfNotPresent(key, null);
    }

    public V getAddIfNotPresent(K key, Supplier<V> newCreator) {
        return this.modify(key, newCreator, this.noModificationModifier, true);
    }

    private class NoModificationModifier
    implements Function<V, V> {
        private NoModificationModifier() {
        }

        public V apply(V input) {
            return input;
        }
    }

    public static class Builder<K, V> {
        protected final ChangingValueCache<K, V> instance = this.createInstance();

        protected Builder() {
        }

        protected ChangingValueCache<K, V> createInstance() {
            return new ChangingValueCache();
        }

        public Builder<K, V> defaultNewCreator(Supplier<V> newCreator) {
            this.instance.defaultNewCreator = newCreator;
            return this;
        }

        public Builder<K, V> defaultModifier(Function<V, V> modifier) {
            this.instance.defaultModifier = modifier;
            return this;
        }

        public Builder<K, V> cache(Cache<K, V> cache) {
            this.instance.cache = cache;
            return this;
        }

        public ChangingValueCache<K, V> build() {
            if (this.instance.getAllCaches().size() < 1) {
                throw new RuntimeException("No inner cache(s) set");
            }
            return this.instance;
        }
    }
}

