/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.sourceforge.peers.FileLogger;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.EventManager;
import net.sourceforge.peers.gui.Registration;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.javaxsound.JavaxSoundManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class MainFrame
implements WindowListener,
ActionListener {
    private JFrame mainFrame;
    private JPanel mainPanel;
    private JPanel dialerPanel;
    private JTextField uri;
    private JButton actionButton;
    private JLabel statusLabel;
    private EventManager eventManager;
    private Registration registration;
    private Logger logger;

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.createAndShowGUI(args);
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        new MainFrame(args);
    }

    public MainFrame(final String[] args) {
        String peersHome = ".";
        if (args.length > 0) {
            peersHome = args[0];
        }
        this.logger = new FileLogger(peersHome);
        String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception e) {
            this.logger.error("cannot change look and feel", e);
        }
        JavaxSoundManager soundManager = new JavaxSoundManager(false, this.logger, peersHome);
        String title = "";
        if (!".".equals(peersHome)) {
            title = peersHome;
        }
        title = title + "/Peers: SIP User-Agent";
        this.mainFrame = new JFrame(title);
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.addWindowListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.dialerPanel = new JPanel();
        this.uri = new JTextField("sip:", 15);
        this.uri.addActionListener(this);
        this.actionButton = new JButton("Call");
        this.actionButton.addActionListener(this);
        this.dialerPanel.add(this.uri);
        this.dialerPanel.add(this.actionButton);
        this.dialerPanel.setAlignmentX(0.0f);
        this.statusLabel = new JLabel(title);
        this.statusLabel.setAlignmentX(0.0f);
        Border border = BorderFactory.createEmptyBorder(0, 2, 2, 2);
        this.statusLabel.setBorder(border);
        this.mainPanel.add(this.dialerPanel);
        this.mainPanel.add(this.statusLabel);
        Container contentPane = this.mainFrame.getContentPane();
        contentPane.add(this.mainPanel);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic('x');
        menuItem.setActionCommand("Exit");
        this.registration = new Registration(this.statusLabel, this.logger);
        Thread thread = new Thread(new Runnable((AbstractSoundManager)soundManager){
            final /* synthetic */ AbstractSoundManager val$soundManager;
            {
                this.val$soundManager = abstractSoundManager;
            }

            @Override
            public void run() {
                String peersHome = ".";
                if (args.length > 0) {
                    peersHome = args[0];
                }
                MainFrame.this.eventManager = new EventManager(MainFrame.this, peersHome, MainFrame.this.logger, this.val$soundManager);
                MainFrame.this.eventManager.register();
            }
        }, "gui-event-manager");
        thread.start();
        try {
            while (this.eventManager == null) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        menuItem.addActionListener(this.eventManager);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menuItem = new JMenuItem("Account");
        menuItem.setMnemonic('A');
        menuItem.setActionCommand("Account");
        menuItem.addActionListener(this.eventManager);
        menu.add(menuItem);
        menuItem = new JMenuItem("Preferences");
        menuItem.setMnemonic('P');
        menuItem.setActionCommand("Preferences");
        menuItem.addActionListener(this.eventManager);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        menuItem = new JMenuItem("User manual");
        menuItem.setMnemonic('D');
        menuItem.setActionCommand("Documentation");
        menuItem.addActionListener(this.eventManager);
        menu.add(menuItem);
        menuItem = new JMenuItem("About");
        menuItem.setMnemonic('A');
        menuItem.setActionCommand("About");
        menuItem.addActionListener(this.eventManager);
        menu.add(menuItem);
        menuBar.add(menu);
        this.mainFrame.setJMenuBar(menuBar);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.eventManager.windowClosed();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.eventManager.callClicked(this.uri.getText());
    }

    public void setLabelText(String text) {
        this.statusLabel.setText(text);
        this.mainFrame.pack();
    }

    public void registerFailed(SipResponse sipResponse) {
        this.registration.registerFailed();
    }

    public void registerSuccessful(SipResponse sipResponse) {
        this.registration.registerSuccessful();
    }

    public void registering(SipRequest sipRequest) {
        this.registration.registerSent();
    }

    public void socketExceptionOnStartup() {
        JOptionPane.showMessageDialog(this.mainFrame, "peers SIP port unavailable, exiting");
        System.exit(1);
    }
}

