/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.CallFrame;
import net.sourceforge.peers.gui.CallFrameState;
import net.sourceforge.peers.sip.transport.SipResponse;

public class CallFrameStateUac
extends CallFrameState {
    public CallFrameStateUac(String id, CallFrame callFrame, Logger logger) {
        super(id, callFrame, logger);
        this.callPanel = new JPanel();
        this.callPanel.add(new JLabel("Calling"));
        JButton hangupButton = new JButton("Hangup");
        hangupButton.setActionCommand("hangup");
        hangupButton.addActionListener(callFrame);
        this.callPanel.add(hangupButton);
    }

    @Override
    public void hangupClicked() {
        this.callFrame.setState(this.callFrame.TERMINATED);
        this.callFrame.hangup();
        this.callFrame.close();
    }

    @Override
    public void calleePickup() {
        this.callFrame.setState(this.callFrame.SUCCESS);
        this.callFrame.setCallPanel(this.callFrame.SUCCESS.callPanel);
    }

    @Override
    public void error(SipResponse sipResponse) {
        this.callFrame.setState(this.callFrame.FAILED);
        this.callFrame.setCallPanel(this.callFrame.FAILED.callPanel);
        this.callFrame.addPageEndLabel("Reason: " + sipResponse.getReasonPhrase());
    }

    @Override
    public void ringing() {
        this.callFrame.setState(this.callFrame.RINGING);
        this.callFrame.setCallPanel(this.callFrame.RINGING.callPanel);
    }
}

