/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.Registration;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class AccountFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Logger logger;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPasswordField jPasswordField1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField4;
    private boolean unregistering;
    private UserAgent userAgent;
    private Registration registration;

    public AccountFrame(UserAgent userAgent, Logger logger) {
        this.userAgent = userAgent;
        this.logger = logger;
        this.unregistering = false;
        this.initComponents();
        this.registration = new Registration(this.jLabel6, logger);
    }

    private void initComponents() {
        SipURI outboundProxy;
        String password;
        String domain;
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPasswordField1 = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Account");
        Config config = this.userAgent.getConfig();
        String userPart = config.getUserPart();
        if (userPart != null) {
            this.jTextField1.setText(userPart);
        }
        if ((domain = config.getDomain()) != null) {
            this.jTextField2.setText(domain);
        }
        if ((password = config.getPassword()) != null) {
            this.jPasswordField1.setText(password);
        }
        if ((outboundProxy = config.getOutboundProxy()) != null) {
            this.jTextField4.setText(outboundProxy.toString());
        }
        this.jLabel1.setText("User");
        this.jLabel2.setText("Domain");
        this.jLabel3.setText("Password");
        this.jLabel4.setText("Outbound Proxy");
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel5.setText("Account management");
        this.jButton1.setText("Apply");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountFrame.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -1, 204, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 204, Short.MAX_VALUE).addComponent(this.jPasswordField1, -1, 204, Short.MAX_VALUE).addComponent(this.jTextField4, -1, 204, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 150, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel5).addGap(168, 168, 168)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, 25, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, 25, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jPasswordField1, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, 25, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jLabel6)).addGap(7, 7, 7)));
        this.pack();
    }

    private void applyNewConfig() {
        String outboundProxy;
        char[] password;
        String domain;
        Config config = this.userAgent.getConfig();
        String userpart = this.jTextField1.getText();
        if (userpart != null) {
            config.setUserPart(userpart);
        }
        if ((domain = this.jTextField2.getText()) != null) {
            config.setDomain(domain);
        }
        if ((password = this.jPasswordField1.getPassword()) != null && password.length > 0) {
            config.setPassword(new String(password));
        }
        if ((outboundProxy = this.jTextField4.getText()) != null) {
            try {
                if ("".equals(outboundProxy.trim())) {
                    config.setOutboundProxy(null);
                } else {
                    if (!outboundProxy.startsWith("sip")) {
                        outboundProxy = "sip:" + outboundProxy;
                    }
                    SipURI sipURI = new SipURI(outboundProxy);
                    config.setOutboundProxy(sipURI);
                }
            }
            catch (SipUriSyntaxException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                this.logger.error("sip uri syntax issue", (Exception)((Object)e));
                return;
            }
        }
        config.save();
        this.unregistering = false;
        if (password != null && password.length > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        AccountFrame.this.userAgent.register();
                    }
                    catch (SipUriSyntaxException e) {
                        JOptionPane.showMessageDialog(AccountFrame.this, e.getMessage());
                        AccountFrame.this.logger.error("sip uri syntax issue", (Exception)((Object)e));
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public void registering(SipRequest sipRequest) {
        this.registration.registerSent();
    }

    public synchronized void registerSuccess(SipResponse sipResponse) {
        if (this.unregistering) {
            this.userAgent.close();
            this.applyNewConfig();
        } else {
            this.registration.registerSuccessful();
        }
    }

    public void registerFailed(SipResponse sipResponse) {
        if (this.unregistering) {
            this.userAgent.close();
            this.applyNewConfig();
        } else {
            this.registration.registerFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton1ActionPerformed(ActionEvent evt) {
        Runnable runnable;
        if (this.userAgent.isRegistered()) {
            AccountFrame accountFrame = this;
            synchronized (accountFrame) {
                this.unregistering = true;
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        AccountFrame.this.userAgent.unregister();
                    }
                    catch (SipUriSyntaxException e) {
                        AccountFrame.this.logger.error("syntax error", (Exception)((Object)e));
                    }
                }
            };
        } else {
            runnable = new Runnable(){

                @Override
                public void run() {
                    AccountFrame.this.userAgent.close();
                    AccountFrame.this.applyNewConfig();
                }
            };
        }
        SwingUtilities.invokeLater(runnable);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

