/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.demo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.peers.demo.EventManager;

public class CommandsReader
extends Thread {
    public static final String CALL = "call";
    public static final String HANGUP = "hangup";
    private boolean isRunning;
    private EventManager eventManager;

    public CommandsReader(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void run() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.setRunning(true);
        while (this.isRunning()) {
            String command;
            try {
                command = bufferedReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            command = command.trim();
            if (command.startsWith(CALL)) {
                String callee = command.substring(command.lastIndexOf(32) + 1);
                this.eventManager.call(callee);
                continue;
            }
            if (command.startsWith(HANGUP)) {
                this.eventManager.hangup();
                continue;
            }
            System.out.println("unknown command " + command);
        }
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }
}

