/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics;

import ae.teletronics.CommandType;
import ae.teletronics.InputCommand;
import ae.teletronics.UserManagement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public abstract class ExternalAuth
implements UserManagement {
    public void readInput() throws IOException {
        this.readInput(new BufferedReader(new InputStreamReader(System.in)));
    }

    public void setup() {
    }

    public void readInput(BufferedReader bufferedReader) throws IOException {
        block0: while (true) {
            int ret;
            int startPos;
            int ret2;
            byte[] lB = new byte[2];
            for (startPos = 0; startPos < lB.length; startPos += ret2) {
                ret2 = System.in.read(lB, startPos, lB.length - startPos);
                if (ret2 < 0) break block0;
            }
            int streamLen = System.in.available();
            byte[] rd = new byte[streamLen];
            for (startPos = 0; startPos < streamLen; startPos += ret) {
                ret = System.in.read(rd, startPos, streamLen - startPos);
                if (ret < 0) break block0;
            }
            String inputCommand = new String(rd, "ASCII");
            this.gotCommand(inputCommand);
        }
    }

    void gotCommand(String inputCommand) throws IOException {
        InputCommand command = this.parseInput(inputCommand);
        if (command.commandType != CommandType.UNKNOWN) {
            boolean status = this.runCommand(command);
            this.writeOutput(status);
        }
    }

    void writeOutput(boolean commandStatus) throws IOException {
        byte[] res = new byte[]{0, 2, 0, commandStatus ? (byte)1 : 0};
        System.out.write(res, 0, res.length);
        System.out.flush();
    }

    InputCommand parseInput(String input) {
        String[] args = input.split(":");
        if (args.length >= 3) {
            HashMap<String, String> commandsMap = new HashMap<String, String>();
            CommandType commandType = CommandType.fromString(args[0]);
            commandsMap.put("user", args[1]);
            commandsMap.put("server", args[2]);
            if (args.length == 4) {
                commandsMap.put("password", args[3]);
            }
            return new InputCommand(commandType, commandsMap);
        }
        return new InputCommand(CommandType.UNKNOWN);
    }

    private boolean runCommand(InputCommand command) {
        boolean status = false;
        switch (command.commandType) {
            case AUTHENTICATE: {
                status = this.authenticate(command.inputParameters.get("user"), command.inputParameters.get("server"), command.inputParameters.get("password"));
                break;
            }
            case EXISTS: {
                status = this.exists(command.inputParameters.get("user"), command.inputParameters.get("server"));
                break;
            }
            case SET_PASS: {
                status = this.setPassword(command.inputParameters.get("user"), command.inputParameters.get("server"), command.inputParameters.get("password"));
                break;
            }
            case TRY_REGISTER: {
                status = this.register(command.inputParameters.get("user"), command.inputParameters.get("server"), command.inputParameters.get("password"));
                break;
            }
            case REMOVE_USER: {
                status = this.remove(command.inputParameters.get("user"), command.inputParameters.get("server"));
                break;
            }
            case REMOVE_SAFELY: {
                status = this.removeSafely(command.inputParameters.get("user"), command.inputParameters.get("server"), command.inputParameters.get("password"));
            }
        }
        return status;
    }
}

