/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.ejabberd;

import ae.teletronics.ejabberd.IEjabberdXMLRPCClient;
import ae.teletronics.ejabberd.ResponseParser;
import ae.teletronics.ejabberd.entity.response.BooleanXmppResponse;
import ae.teletronics.ejabberd.entity.response.GetRosterResponse;
import ae.teletronics.ejabberd.entity.response.GetUserPairListResponse;
import ae.teletronics.ejabberd.entity.response.GetUsersResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

public class EjabberdXMLRPCClient
implements IEjabberdXMLRPCClient {
    ExecutorService executorService;
    XmlRpcClient client = new XmlRpcClient();
    ResponseParser responseParser = new ResponseParser();

    public EjabberdXMLRPCClient(ExecutorService executorService, XmlRpcClient client) {
        this.executorService = executorService;
        this.client = client;
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> createUser(String username, String host, String password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", username);
        params.put("host", host);
        params.put("password", password);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap createUserXMLRPCResponse = this.executeXmlRpc("register", Arrays.asList(params));
                return this.responseParser.parseBooleanResponse(createUserXMLRPCResponse);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> deleteUser(String username, String host) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", username);
        params.put("host", host);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap deleteUserXMLRPCResponse = this.executeXmlRpc("unregister", Arrays.asList(params));
                return this.responseParser.parseBooleanResponse(deleteUserXMLRPCResponse);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<GetUsersResponse> getUsers(String host) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", host);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("registered_users", Arrays.asList(params));
                GetUsersResponse getUsersResponse = this.responseParser.parseGetUserResponse(response);
                return getUsersResponse;
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> addRosterItem(String localuser, String localserver, String user, String server, String nick, String group, String subs) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("localuser", localuser);
        params.put("localserver", localserver);
        params.put("user", user);
        params.put("server", server);
        params.put("nick", nick);
        params.put("group", group);
        params.put("subs", subs);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("add_rosteritem", Arrays.asList(params));
                BooleanXmppResponse booleanXmppResponse = this.responseParser.parseBooleanResponse(response);
                return booleanXmppResponse;
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> deleteRosterItem(String localuser, String localserver, String user, String server) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("localuser", localuser);
        params.put("localserver", localserver);
        params.put("server", server);
        params.put("user", user);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("delete_rosteritem", Arrays.asList(params));
                return this.responseParser.parseBooleanResponse(response);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<GetRosterResponse> getRoster(String user, String server) {
        HashMap<String, String> struct = new HashMap<String, String>();
        struct.put("user", user);
        struct.put("server", server);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("get_roster", Arrays.asList(struct));
                return this.responseParser.parseGetRosterResponse(response);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> sendChatMessage(String to, String from, String subject, String body) {
        HashMap<String, String> struct = new HashMap<String, String>();
        struct.put("type", "chat");
        struct.put("to", to);
        struct.put("from", from);
        struct.put("subject", subject);
        struct.put("body", body);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("send_message", Arrays.asList(struct));
                return this.responseParser.parseBooleanResponse(response);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<BooleanXmppResponse> sendStanza(String to, String from, String stanza) {
        HashMap<String, String> struct = new HashMap<String, String>();
        struct.put("to", to);
        struct.put("from", from);
        struct.put("stanza", stanza);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("send_stanza", Arrays.asList(struct));
                return this.responseParser.parseBooleanResponse(response);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    @Override
    public CompletableFuture<GetUserPairListResponse> processRosterItems(String action, String subs, String asks, String users, String contacts) {
        HashMap<String, String> struct = new HashMap<String, String>();
        struct.put("action", action);
        struct.put("subs", subs);
        struct.put("asks", asks);
        struct.put("users", users);
        struct.put("contacts", contacts);
        return CompletableFuture.supplyAsync(() -> {
            try {
                HashMap response = this.executeXmlRpc("process_rosteritems", Arrays.asList(struct));
                return this.responseParser.parseUserPairListResponse(response);
            }
            catch (XmlRpcException e) {
                throw new CompletionException(e);
            }
        }, this.executorService);
    }

    HashMap executeXmlRpc(String command, List params) throws XmlRpcException {
        return (HashMap)this.client.execute(command, params);
    }
}

