/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.ejabberd;

import ae.teletronics.ejabberd.EjabberdXMLRPCClient;
import ae.teletronics.ejabberd.IEjabberdXMLRPCClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class EjabberdXMLRPCClientBuilder {
    ExecutorService executorService = Executors.newCachedThreadPool();
    String ejabberdHostname = "localhost";
    String ejabberdPort = "4560";
    String ejabberdProtocol = "http";
    String ejabberdPath = "/RPC2";

    public EjabberdXMLRPCClientBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public EjabberdXMLRPCClientBuilder setEjabberdHostname(String ejabberdHostname) {
        this.ejabberdHostname = ejabberdHostname;
        return this;
    }

    public EjabberdXMLRPCClientBuilder setEjabberdPort(String ejabberdPort) {
        this.ejabberdPort = ejabberdPort;
        return this;
    }

    public EjabberdXMLRPCClientBuilder setEjabberdProtocol(String ejabberdProtocol) {
        this.ejabberdProtocol = ejabberdProtocol;
        return this;
    }

    public EjabberdXMLRPCClientBuilder setEjabberdPath(String ejabberdPath) {
        this.ejabberdPath = ejabberdPath;
        return this;
    }

    public IEjabberdXMLRPCClient build() throws MalformedURLException {
        URL ejabberdUrl = this.buildUrl();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(ejabberdUrl);
        XmlRpcClient client = new XmlRpcClient();
        client.setConfig((XmlRpcClientConfig)config);
        return new EjabberdXMLRPCClient(this.executorService, client);
    }

    URL buildUrl() throws MalformedURLException {
        return new URL(this.ejabberdProtocol, this.ejabberdHostname, Integer.parseInt(this.ejabberdPort), this.ejabberdPath);
    }
}

