/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.activemq.TransactionContext;

public class LocalAndXATransaction
implements XAResource,
LocalTransaction {
    private final TransactionContext transactionContext;
    private boolean inManagedTx;

    public LocalAndXATransaction(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public void setInManagedTx(boolean inManagedTx) throws JMSException {
        this.inManagedTx = inManagedTx;
    }

    public void begin() throws ResourceException {
        try {
            this.transactionContext.begin();
            this.setInManagedTx(true);
        }
        catch (JMSException e) {
            throw new ResourceException("begin failed.", (Throwable)e);
        }
    }

    public void commit() throws ResourceException {
        try {
            this.transactionContext.commit();
        }
        catch (JMSException e) {
            throw new ResourceException("commit failed.", (Throwable)e);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw new ResourceException("commit failed.", (Throwable)e);
            }
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.transactionContext.rollback();
        }
        catch (JMSException e) {
            throw new ResourceException("rollback failed.", (Throwable)e);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw new ResourceException("rollback failed.", (Throwable)e);
            }
        }
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        this.transactionContext.commit(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid arg0, int arg1) throws XAException {
        try {
            this.transactionContext.end(arg0, arg1);
        }
        finally {
            try {
                this.setInManagedTx(false);
            }
            catch (JMSException e) {
                throw (XAException)new XAException(-6).initCause(e);
            }
        }
    }

    public void forget(Xid arg0) throws XAException {
        this.transactionContext.forget(arg0);
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionContext.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaresource) throws XAException {
        if (xaresource == null) {
            return false;
        }
        if (xaresource instanceof LocalAndXATransaction) {
            xaresource = ((LocalAndXATransaction)xaresource).transactionContext;
        }
        return this.transactionContext.isSameRM(xaresource);
    }

    public int prepare(Xid arg0) throws XAException {
        return this.transactionContext.prepare(arg0);
    }

    public Xid[] recover(int arg0) throws XAException {
        return this.transactionContext.recover(arg0);
    }

    public void rollback(Xid arg0) throws XAException {
        this.transactionContext.rollback(arg0);
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return this.transactionContext.setTransactionTimeout(arg0);
    }

    public void start(Xid arg0, int arg1) throws XAException {
        this.transactionContext.start(arg0, arg1);
        try {
            this.setInManagedTx(true);
        }
        catch (JMSException e) {
            throw (XAException)new XAException(-6).initCause(e);
        }
    }

    public boolean isInManagedTx() {
        return this.inManagedTx;
    }
}

