/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.ra;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.XmlConfigHelper;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.BrokerContainerFactory;
import org.activemq.broker.BrokerContext;
import org.activemq.ra.ActiveMQActivationSpec;
import org.activemq.ra.ActiveMQAsfEndpointWorker;
import org.activemq.ra.ActiveMQBaseEndpointWorker;
import org.activemq.ra.ActiveMQConnectionRequestInfo;
import org.activemq.ra.ActiveMQEndpointActivationKey;
import org.activemq.ra.ActiveMQPollingEndpointWorker;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQResourceAdapter
implements ResourceAdapter {
    private static final Log log = LogFactory.getLog((Class)ActiveMQResourceAdapter.class);
    private static final String ASF_ENDPOINT_WORKER_TYPE = "asf";
    private static final String POLLING_ENDPOINT_WORKER_TYPE = "polling";
    private BootstrapContext bootstrapContext;
    private HashMap endpointWorkers = new HashMap();
    private final ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    private String endpointWorkerType = "asf";
    private ActiveMQConnectionFactory connectionFactory;
    private BrokerContainer container;
    private Boolean useEmbeddedBroker;
    private String brokerXmlConfig;
    private HashMap connectionFactoryMap = new HashMap(1);

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        if (this.isUseEmbeddedBroker() != null && this.isUseEmbeddedBroker().booleanValue()) {
            this.createBroker();
        }
    }

    private void createBroker() throws ResourceAdapterInternalException {
        try {
            BrokerContainerFactory brokerContainerFactory = XmlConfigHelper.createBrokerContainerFactory((String)this.getBrokerXmlConfig());
            IdGenerator idgen = new IdGenerator();
            this.container = brokerContainerFactory.createBrokerContainer(idgen.generateId(), BrokerContext.getInstance());
            this.container.start();
            this.connectionFactory = new ActiveMQConnectionFactory(this.container, this.getServerUrl());
        }
        catch (JMSException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new ResourceAdapterInternalException("Failed to startup an embedded broker", (Throwable)e);
        }
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        return this.makeConnection(this.info);
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo crInfo) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.getConnectionFactory(crInfo);
        String userName = this.info.getUserName();
        String password = this.info.getPassword();
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        String clientId = this.info.getClientid();
        if (clientId != null) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public ActiveMQConnection makeConnection(ActiveMQActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.getConnectionFactory(this.info);
        String userName = this.defaultValue(activationSpec.getUserName(), this.info.getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.info.getPassword());
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        if (activationSpec.isDurableSubscription()) {
            physicalConnection.setClientID(activationSpec.getClientId());
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveMQConnectionFactory getConnectionFactory(ActiveMQConnectionRequestInfo crInfo) {
        if (crInfo == null) {
            crInfo = this.info;
        }
        if (!this.connectionFactoryMap.containsKey(crInfo)) {
            HashMap hashMap = this.connectionFactoryMap;
            synchronized (hashMap) {
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(crInfo.getServerUrl());
                this.connectionFactoryMap.put(crInfo, factory);
                return factory;
            }
        }
        return (ActiveMQConnectionFactory)this.connectionFactoryMap.get(crInfo);
    }

    private String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void stop() {
        while (this.endpointWorkers.size() > 0) {
            ActiveMQEndpointActivationKey key = (ActiveMQEndpointActivationKey)this.endpointWorkers.keySet().iterator().next();
            this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
        }
        this.stopBroker();
        this.bootstrapContext = null;
    }

    private void stopBroker() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (JMSException e) {
                log.warn((Object)"Exception while stopping the broker container", (Throwable)e);
            }
        }
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        ActiveMQBaseEndpointWorker worker;
        if (activationSpec.getResourceAdapter() != this) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance");
        }
        if (!activationSpec.getClass().equals(ActiveMQActivationSpec.class)) throw new NotSupportedException("That type of ActicationSpec not supported: " + activationSpec.getClass());
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        if (POLLING_ENDPOINT_WORKER_TYPE.equals(this.getEndpointWorkerType())) {
            worker = new ActiveMQPollingEndpointWorker(this, key);
        } else {
            if (!ASF_ENDPOINT_WORKER_TYPE.equals(this.getEndpointWorkerType())) throw new NotSupportedException("That type of EndpointWorkerType is not supported: " + this.getEndpointWorkerType());
            worker = new ActiveMQAsfEndpointWorker(this, key);
        }
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec.getClass().equals(ActiveMQActivationSpec.class)) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (ActiveMQActivationSpec)activationSpec);
            ActiveMQBaseEndpointWorker worker = (ActiveMQBaseEndpointWorker)this.endpointWorkers.remove(key);
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        XAResource[] session2;
        ActiveMQConnection connection = null;
        try {
            connection = this.makeConnection();
            if (connection instanceof XAConnection) {
                XASession session2 = ((XAConnection)connection).createXASession();
                XAResource xaResource = session2.getXAResource();
                XAResource[] xAResourceArray = new XAResource[]{xaResource};
                return xAResourceArray;
            }
            session2 = new XAResource[]{};
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable ignore) {}
        }
        return session2;
    }

    public String getClientid() {
        return this.emptyToNull(this.info.getClientid());
    }

    public String getPassword() {
        return this.emptyToNull(this.info.getPassword());
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public String getUserName() {
        return this.emptyToNull(this.info.getUserName());
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setServerUrl(String url) {
        this.info.setServerUrl(url);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public String getEndpointWorkerType() {
        return this.endpointWorkerType;
    }

    public void setEndpointWorkerType(String endpointWorkerType) {
        this.endpointWorkerType = endpointWorkerType.toLowerCase();
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public Boolean isUseEmbeddedBroker() {
        return this.useEmbeddedBroker;
    }

    public void setUseEmbeddedBroker(Boolean useEmbeddedBroker) {
        this.useEmbeddedBroker = useEmbeddedBroker;
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQResourceAdapter)) {
            return false;
        }
        ActiveMQResourceAdapter activeMQResourceAdapter = (ActiveMQResourceAdapter)o;
        if (!this.endpointWorkerType.equals(activeMQResourceAdapter.endpointWorkerType)) {
            return false;
        }
        if (!this.info.equals(activeMQResourceAdapter.info)) {
            return false;
        }
        if (this.notEqual(this.useEmbeddedBroker, activeMQResourceAdapter.useEmbeddedBroker)) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.brokerXmlConfig);
    }

    private boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    public int hashCode() {
        int result = this.info.hashCode();
        result = 29 * result + this.endpointWorkerType.hashCode();
        if (this.useEmbeddedBroker != null && this.useEmbeddedBroker.booleanValue()) {
            result = result * 29 + 1;
        }
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    private String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public Boolean getUseEmbeddedBroker() {
        return this.useEmbeddedBroker;
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.info.setUseInboundSession(useInboundSession);
    }
}

