/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.itest.ejb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDBTransferBean
implements MessageDrivenBean,
MessageListener {
    private static final Log log = LogFactory.getLog((Class)MDBTransferBean.class);
    private MessageDrivenContext messageDrivenContext;
    private Context envContext;

    public void ejbCreate() {
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        try {
            this.messageDrivenContext = messageDrivenContext;
            this.envContext = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        System.out.println("entering onMessage");
        try {
            ConnectionFactory cf = (ConnectionFactory)this.envContext.lookup("jms/Default");
            Connection con = cf.createConnection();
            try {
                Session session = con.createSession(true, 0);
                Destination dest = (Destination)this.envContext.lookup("MDBOut");
                MessageProducer producer = session.createProducer(dest);
                producer.setDeliveryMode(message.getJMSDeliveryMode());
                producer.send(message);
            }
            finally {
                con.close();
            }
        }
        catch (Throwable e) {
            log.info((Object)e);
        }
        System.out.println("leaving onMessage");
    }

    private void printCompEnv() throws NamingException {
        log.warn((Object)"Printing java:comp/env/jms context: ");
        Context c = (Context)new InitialContext().lookup("java:comp/env/jms");
        NamingEnumeration<NameClassPair> iter = c.list("");
        while (iter.hasMoreElements()) {
            NameClassPair pair = iter.next();
            log.warn((Object)("'" + pair.getName() + "'"));
        }
    }
}

