/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.itest.ejb;

import java.rmi.RemoteException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessengerBean
implements SessionBean {
    private static final Log log = LogFactory.getLog((Class)MessengerBean.class);
    private SessionContext sessionContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String text, int reps) throws RemoteException, NamingException, JMSException {
        log.info((Object)"sendMessage start");
        this.printCompEnv();
        InitialContext jndiContext = new InitialContext();
        ConnectionFactory cf = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/Default");
        Connection con = cf.createConnection();
        try {
            Session session = con.createSession(true, 0);
            Queue q = (Queue)jndiContext.lookup("java:comp/env/jms/SendQueue");
            MessageProducer producer = session.createProducer((Destination)q);
            for (int i = 0; i < reps; ++i) {
                log.info((Object)("Sending message: " + i));
                producer.send((Message)session.createTextMessage(text + ":" + i));
            }
        }
        finally {
            log.info((Object)"sendMessage end");
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Destination dest, String text, int reps) throws RemoteException, NamingException, JMSException {
        log.info((Object)"sendMessage start");
        this.printCompEnv();
        InitialContext jndiContext = new InitialContext();
        ConnectionFactory cf = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/Default");
        Connection con = cf.createConnection();
        try {
            Session session = con.createSession(true, 0);
            MessageProducer producer = session.createProducer(dest);
            for (int i = 0; i < reps; ++i) {
                log.info((Object)("Sending message: " + i));
                producer.send((Message)session.createTextMessage(text + ":" + i));
            }
        }
        finally {
            log.info((Object)"sendMessage end");
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Destination dest, String text) throws RemoteException, NamingException, JMSException {
        log.info((Object)"sendMessage start");
        this.printCompEnv();
        InitialContext jndiContext = new InitialContext();
        ConnectionFactory cf = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/Default");
        Connection con = cf.createConnection();
        try {
            Session session = con.createSession(true, 0);
            MessageProducer producer = session.createProducer(dest);
            producer.send((Message)session.createTextMessage(text));
        }
        finally {
            log.info((Object)"sendMessage end");
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveMessage(Destination dest, long timeout) throws RemoteException, NamingException, JMSException {
        log.info((Object)"receiveMessage start");
        InitialContext jndiContext = new InitialContext();
        ConnectionFactory cf = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/Default");
        Connection con = cf.createConnection();
        con.start();
        boolean received = false;
        try {
            Session session = con.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer(dest);
            TextMessage message = null;
            message = (TextMessage)consumer.receive(timeout);
            String string = message.getText();
            return string;
        }
        finally {
            log.info((Object)"receiveMessage end");
            con.close();
        }
    }

    private void printCompEnv() throws NamingException {
        log.warn((Object)"Printing java:comp/env/jms context: ");
        Context c = (Context)new InitialContext().lookup("java:comp/env/jms");
        NamingEnumeration<NameClassPair> iter = c.list("");
        while (iter.hasMoreElements()) {
            NameClassPair pair = iter.next();
            log.warn((Object)("'" + pair.getName() + "'"));
        }
    }
}

