/*
 * Decompiled with CFR 0.152.
 */
package com.github.art241111.tcpClientLibrary.connection;

import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.github.art241111.tcpClientLibrary.connection.ConnectInt;
import com.github.art241111.tcpClientLibrary.connection.Status;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/github/art241111/tcpClientLibrary/connection/Connection;", "Landroidx/lifecycle/LiveData;", "Ljava/net/Socket;", "Lcom/github/art241111/tcpClientLibrary/connection/ConnectInt;", "()V", "connectStatus", "Landroidx/lifecycle/MutableLiveData;", "Lcom/github/art241111/tcpClientLibrary/connection/Status;", "connect", "", "address", "", "port", "", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectToTheServer", "disconnect", "getConnectStatus", "TCPClientLibrary_debug"})
public final class Connection
extends LiveData<Socket>
implements ConnectInt {
    private final MutableLiveData<Status> connectStatus = new MutableLiveData();

    @Override
    @NotNull
    public LiveData<Status> getConnectStatus() {
        return (LiveData)this.connectStatus;
    }

    @Override
    public void disconnect() {
        Object object = this.connectStatus.getValue();
        Intrinsics.checkNotNull((Object)object);
        if ((Status)((Object)object) == Status.COMPLETED) {
            Socket socket = (Socket)this.getValue();
            Intrinsics.checkNotNull((Object)socket);
            socket.close();
            this.connectStatus.postValue((Object)Status.DISCONNECTED);
            this.postValue(new Socket());
        }
    }

    @Override
    @Nullable
    public Object connect(@NotNull String address, int port, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, address, port, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Connection this$0;
            final /* synthetic */ String $address;
            final /* synthetic */ int $port;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$withContext = this.p$;
                        Connection.access$connectToTheServer(this.this$0, this.$address, this.$port);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = connection;
                this.$address = string;
                this.$port = n;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void connectToTheServer(String address, int port) {
        block6: {
            block5: {
                Object object = this.connectStatus.getValue();
                Intrinsics.checkNotNull((Object)object);
                if ((Status)((Object)object) == Status.DISCONNECTED) break block5;
                Object object2 = this.connectStatus.getValue();
                Intrinsics.checkNotNull((Object)object2);
                if ((Status)((Object)object2) != Status.ERROR) break block6;
            }
            try {
                this.connectStatus.postValue((Object)Status.CONNECTING);
                Socket socket = (Socket)this.getValue();
                Intrinsics.checkNotNull((Object)socket);
                socket.connect(new InetSocketAddress(address, port), 2000);
                this.connectStatus.postValue((Object)Status.COMPLETED);
            }
            catch (SocketTimeoutException e) {
                this.connectStatus.postValue((Object)Status.ERROR);
                this.postValue(new Socket());
            }
            catch (Exception e) {
                Log.e((String)"client_connection", (String)"Fail connection", (Throwable)e);
                this.connectStatus.postValue((Object)Status.ERROR);
                this.postValue(new Socket());
            }
        }
    }

    public Connection() {
        this.connectStatus.setValue((Object)Status.DISCONNECTED);
        this.postValue(new Socket());
    }

    public static final /* synthetic */ void access$connectToTheServer(Connection $this, String address, int port) {
        $this.connectToTheServer(address, port);
    }
}

