/*
 * Decompiled with CFR 0.152.
 */
package kr.seongil.recyclerview.viewbinder;

import android.support.annotation.NonNull;
import android.support.v4.util.SparseArrayCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.ViewGroup;
import java.util.List;
import kr.seongil.recyclerview.utils.RecyclerViewUtils;
import kr.seongil.recyclerview.viewbinder.ViewBinder;

public class ViewBinderListManager<T extends List> {
    private static final String TAG = "SmartRecyclerView";
    private static final String LOG_PREFIX = RecyclerViewUtils.getPrefix("ViewBinderListManager");
    private SparseArrayCompat<ViewBinder<T>> mViewBinderList;

    public ViewBinderListManager() {
        this(8);
    }

    public ViewBinderListManager(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        this.mViewBinderList = new SparseArrayCompat(capacity);
    }

    public boolean addViewBinder(@NonNull ViewBinder<T> viewBinder) {
        RecyclerViewUtils.checkNotNull(viewBinder, "ViewBinder is null. You must pass valid object.");
        int viewType = viewBinder.getItemViewType();
        if (this.existViewBinder(viewBinder)) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append(LOG_PREFIX + "ViewBinder is been registered in ViewBinderList already. type : " + viewType + '\n');
            if (viewType == 1000) {
                sb.append("Requested ViewType is HeaderView type. So, you have to use another type value.");
            } else if (viewType == 1001) {
                sb.append("Requested ViewType is FooterView type. So, you have to use another type value.");
            }
            throw new IllegalArgumentException(TAG + sb.toString());
        }
        this.mViewBinderList.put(viewType, viewBinder);
        return true;
    }

    public boolean removeViewBinder(int viewType) {
        int size = this.mViewBinderList.size();
        for (int i = 0; i < size; ++i) {
            ViewBinder element = (ViewBinder)this.mViewBinderList.valueAt(i);
            if (element.getItemViewType() != viewType) continue;
            this.mViewBinderList.removeAt(i);
            Log.d((String)TAG, (String)(LOG_PREFIX + "Removed the ViewBinder. type : " + viewType));
            return true;
        }
        Log.d((String)TAG, (String)(LOG_PREFIX + "Failed to remove the ViewBinder. (There is no view binder) type : " + viewType));
        return false;
    }

    public boolean existViewBinder(ViewBinder<T> viewBinder) {
        RecyclerViewUtils.checkNotNull(viewBinder, "ViewBinder is null. You must pass a valid object.");
        int viewType = viewBinder.getItemViewType();
        return this.mViewBinderList.get(viewType) != null;
    }

    public int getItemViewType(@NonNull T dataSet, int position) {
        RecyclerViewUtils.checkNotNull(dataSet, "DataSet is null. You must pass a valid dataSet.");
        int size = this.mViewBinderList.size();
        for (int i = 0; i < size; ++i) {
            ViewBinder element = (ViewBinder)this.mViewBinderList.valueAt(i);
            if (!element.isForViewType(dataSet, position)) continue;
            return element.getItemViewType();
        }
        throw new IllegalArgumentException("No ViewBinder added that matches position =" + position + " in data source.\nViewBinder Size is " + this.mViewBinderList.size());
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewBinder viewBinder = (ViewBinder)this.mViewBinderList.get(viewType);
        RecyclerViewUtils.checkNotNull(viewBinder, "No ViewBinder added for ViewType " + viewType);
        return viewBinder.onCreateViewHolder(parent);
    }

    public void onBindViewHolder(@NonNull T items, int position, @NonNull RecyclerView.ViewHolder viewHolder) {
        ViewBinder viewBinder = (ViewBinder)this.mViewBinderList.get(viewHolder.getItemViewType());
        if (viewBinder == null) {
            throw new NullPointerException("No ViewBinder added for ViewType " + viewHolder.getItemViewType());
        }
        viewBinder.onBindViewHolder(items, position, viewHolder);
    }

    public void clear() {
        if (this.mViewBinderList.size() == 0) {
            return;
        }
        this.mViewBinderList.clear();
    }
}

