/*
 * Decompiled with CFR 0.152.
 */
package kr.seongil.recyclerview.viewbinder;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import java.util.List;
import kr.seongil.recyclerview.viewbinder.ViewBinder;

public abstract class AbstractViewBinder<T extends List>
implements ViewBinder<T> {
    public static final int RECYCLER_HEADER_VIEW_TYPE = 1000;
    public static final int RECYCLER_FOOTER_VIEW_TYPE = 1001;
    protected int mViewType;
    protected RecyclerViewItemClickListener mItemViewClickListener;
    protected RecyclerViewItemLongClickListener mItemViewLongClickListener;
    protected LayoutInflater mLayoutInflater;

    public AbstractViewBinder(int viewType, LayoutInflater inflater) {
        this(viewType, inflater, null, null);
    }

    public AbstractViewBinder(int viewType, LayoutInflater inflater, RecyclerViewItemClickListener itemClickListener) {
        this(viewType, inflater, itemClickListener, null);
    }

    public AbstractViewBinder(int viewType, LayoutInflater inflater, RecyclerViewItemLongClickListener itemLongClickListener) {
        this(viewType, inflater, null, itemLongClickListener);
    }

    public AbstractViewBinder(int viewType, LayoutInflater inflater, RecyclerViewItemClickListener itemClickListener, RecyclerViewItemLongClickListener itemLongClickListener) {
        this.mViewType = viewType;
        this.mLayoutInflater = inflater;
        this.mItemViewClickListener = itemClickListener;
        this.mItemViewLongClickListener = itemLongClickListener;
    }

    @Override
    public int getItemViewType() {
        return this.mViewType;
    }

    public static interface RecyclerViewItemLongClickListener<T, V extends RecyclerView.ViewHolder> {
        public void onLongClickedRecyclerViewItem(V var1, T var2, int var3);
    }

    public static interface RecyclerViewItemClickListener<T, V extends RecyclerView.ViewHolder> {
        public void onClickedRecyclerViewItem(V var1, T var2, int var3);
    }
}

