/*
 * Decompiled with CFR 0.152.
 */
package kr.seongil.recyclerview.viewadapter;

import android.view.LayoutInflater;
import kr.seongil.recyclerview.model.common.RecyclerViewHeaderFooterItem;
import kr.seongil.recyclerview.model.common.RecyclerViewItem;
import kr.seongil.recyclerview.model.footerview.RecyclerViewFooterItem;
import kr.seongil.recyclerview.model.headerview.RecyclerViewHeaderItem;
import kr.seongil.recyclerview.utils.RecyclerViewUtils;
import kr.seongil.recyclerview.viewadapter.AbstractRecyclerViewAdapter;
import kr.seongil.recyclerview.viewbinder.AbstractFooterViewBinder;
import kr.seongil.recyclerview.viewbinder.AbstractHeaderViewBinder;
import kr.seongil.recyclerview.viewbinder.AbstractViewBinder;

public abstract class RecyclerListViewAdapter<T extends RecyclerViewItem>
extends AbstractRecyclerViewAdapter<T> {
    private boolean mUseHeaderView;
    private boolean mUseFooterView;
    protected final AbstractViewBinder.RecyclerViewItemClickListener mViewItemClickListener;

    public RecyclerListViewAdapter(LayoutInflater layoutInflater, AbstractViewBinder.RecyclerViewItemClickListener viewItemClickListener) {
        super(layoutInflater);
        this.mViewItemClickListener = viewItemClickListener;
    }

    @Override
    public boolean registeredFooterView() {
        return this.mUseFooterView;
    }

    @Override
    public boolean registeredHeaderView() {
        return this.mUseHeaderView;
    }

    @Override
    public boolean loadFooterItemsMore() {
        return this.mUseFooterView && this.getRecyclerFooterViewItemFromDataSet().autoLoadData();
    }

    @Override
    public boolean loadHeaderItemsMore() {
        return this.mUseHeaderView && this.getRecyclerHeaderViewItemFromDataSet().autoLoadData();
    }

    @Override
    public synchronized void clearDataSet() {
        super.clearDataSet();
        this.mUseHeaderView = false;
        this.mUseFooterView = false;
        this.clearViewBinders();
    }

    protected AbstractFooterViewBinder getNewInstanceOfFooterViewBinder() {
        return null;
    }

    protected RecyclerViewFooterItem getNewInstanceOfFooterItem() {
        return null;
    }

    protected AbstractHeaderViewBinder getNewInstanceOfHeaderViewBinder() {
        return null;
    }

    protected RecyclerViewHeaderItem getNewInstanceOfHeaderItem() {
        return null;
    }

    public void registerFooterView() {
        if (this.mUseFooterView) {
            throw new IllegalArgumentException("Footer item is inserted already.");
        }
        AbstractFooterViewBinder avb = this.getNewInstanceOfFooterViewBinder();
        RecyclerViewUtils.checkNotNull(avb, "Footer View Binder is null. You must override getNewInstanceOfFooterViewBinder()");
        this.addViewBinder(avb);
        RecyclerViewFooterItem footerItem = this.getNewInstanceOfFooterItem();
        RecyclerViewUtils.checkNotNull(footerItem, "Footer View item is null. You must override getNewInstanceOfFooterItem()");
        int position = this.getItemCount();
        this.addPosition(footerItem, position);
        this.mUseFooterView = true;
    }

    public void registerHeaderView() {
        if (this.mUseHeaderView) {
            throw new IllegalArgumentException("Header item is inserted already.");
        }
        AbstractHeaderViewBinder avb = this.getNewInstanceOfHeaderViewBinder();
        RecyclerViewUtils.checkNotNull(avb, "Header View Binder is null. You must override getNewInstanceOfHeaderViewBinder()");
        this.addViewBinder(avb);
        RecyclerViewHeaderItem headerItem = this.getNewInstanceOfHeaderItem();
        RecyclerViewUtils.checkNotNull(headerItem, "Header View Item is null. You must override getNewInstanceOfHeaderItem()");
        this.addPosition(headerItem, 0);
        this.mUseHeaderView = true;
    }

    public void unregisterFooterView() {
        this.removeFooterItem();
        this.removeViewBinder(1001);
        this.mUseFooterView = false;
    }

    public void unregisterHeaderView() {
        this.removeHeaderItem();
        this.removeViewBinder(1000);
        this.mUseHeaderView = false;
    }

    public void updateFooterViewStatus(RecyclerViewHeaderFooterItem.Status code, boolean applyOneCycle) {
        RecyclerViewFooterItem footerItem = this.getRecyclerFooterViewItemFromDataSet();
        RecyclerViewUtils.checkNotNull(footerItem, "Footer View item is null. You must override getNewInstanceOfFooterItem()");
        footerItem.setStatusCode(code, applyOneCycle);
        this.updatePositionWithNotify(footerItem, this.getItemCount() - 1);
    }

    public void updateHeaderViewStatus(RecyclerViewHeaderFooterItem.Status code, boolean applyOneCycle) {
        RecyclerViewHeaderItem headerItem = this.getRecyclerHeaderViewItemFromDataSet();
        RecyclerViewUtils.checkNotNull(headerItem, "Header View item is null. You must override getNewInstanceOfHeaderItem()");
        headerItem.setStatusCode(code, applyOneCycle);
        this.updatePositionWithNotify(headerItem, 0);
    }

    public boolean headerViewStatusCodeIsOneCycle() {
        return this.getRecyclerHeaderViewItemFromDataSet().isApplyOneCycle();
    }

    public boolean footerViewStatusCodeIsOneCycle() {
        return this.getRecyclerFooterViewItemFromDataSet().isApplyOneCycle();
    }

    public void updateHeaderViewStatusCodeForOneCycle(boolean applyOneCycle) {
        RecyclerViewHeaderItem headerItem = this.getRecyclerHeaderViewItemFromDataSet();
        RecyclerViewUtils.checkNotNull(headerItem, "Header View item is null. You must override getNewInstanceOfHeaderItem()");
        headerItem.setApplyOneCycle(applyOneCycle);
        this.updatePositionWithNotify(headerItem, 0);
    }

    public void updateFooterViewStatusCodeForOneCycle(boolean applyOneCycle) {
        RecyclerViewFooterItem footerItem = this.getRecyclerFooterViewItemFromDataSet();
        RecyclerViewUtils.checkNotNull(footerItem, "Footer View item is null. You must override getNewInstanceOfFooterItem()");
        footerItem.setApplyOneCycle(applyOneCycle);
        this.updatePositionWithNotify(footerItem, this.getItemCount() - 1);
    }

    protected RecyclerViewHeaderItem getRecyclerHeaderViewItemFromDataSet() {
        if (!this.mUseHeaderView) {
            throw new RuntimeException("You are not using the header view. You can't update the code of the header view.");
        }
        return (RecyclerViewHeaderItem)this.mDataSet.get(0);
    }

    protected RecyclerViewFooterItem getRecyclerFooterViewItemFromDataSet() {
        if (!this.mUseFooterView) {
            throw new RuntimeException("You are not using the footer view. You can't update the code of the footer view.");
        }
        return (RecyclerViewFooterItem)this.mDataSet.get(this.getItemCount() - 1);
    }
}

