/*
 * Decompiled with CFR 0.152.
 */
package kr.seongil.recyclerview.viewadapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import java.util.List;
import kr.seongil.recyclerview.model.common.RecyclerViewItem;
import kr.seongil.recyclerview.model.footerview.RecyclerViewFooterItem;
import kr.seongil.recyclerview.model.headerview.RecyclerViewHeaderItem;
import kr.seongil.recyclerview.utils.RecyclerViewUtils;
import kr.seongil.recyclerview.viewadapter.RecyclerListViewListener;
import kr.seongil.recyclerview.viewbinder.AbstractViewBinder;
import kr.seongil.recyclerview.viewbinder.ViewBinder;
import kr.seongil.recyclerview.viewbinder.ViewBinderListManager;

public abstract class AbstractRecyclerViewAdapter<T extends RecyclerViewItem>
extends RecyclerView.Adapter
implements RecyclerListViewListener {
    private ViewBinderListManager<List<T>> mViewBinderManager = new ViewBinderListManager();
    protected LayoutInflater mLayoutInflater;
    protected List<T> mDataSet;

    public AbstractRecyclerViewAdapter(LayoutInflater layoutInflater) {
        this.mLayoutInflater = layoutInflater;
    }

    public synchronized List<T> getDataSet() {
        return this.mDataSet;
    }

    public synchronized void setDataSet(List<T> dataSet) {
        this.mDataSet = dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        AbstractRecyclerViewAdapter abstractRecyclerViewAdapter = this;
        synchronized (abstractRecyclerViewAdapter) {
            return this.mViewBinderManager.onCreateViewHolder(parent, viewType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AbstractRecyclerViewAdapter abstractRecyclerViewAdapter = this;
        synchronized (abstractRecyclerViewAdapter) {
            this.mViewBinderManager.onBindViewHolder(this.mDataSet, position, holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemViewType(int position) {
        AbstractRecyclerViewAdapter abstractRecyclerViewAdapter = this;
        synchronized (abstractRecyclerViewAdapter) {
            return this.mViewBinderManager.getItemViewType(this.mDataSet, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        AbstractRecyclerViewAdapter abstractRecyclerViewAdapter = this;
        synchronized (abstractRecyclerViewAdapter) {
            return this.mDataSet == null ? 0 : this.mDataSet.size();
        }
    }

    protected synchronized void clearViewBinders() {
        this.mViewBinderManager.clear();
    }

    protected synchronized boolean addViewBinder(AbstractViewBinder cvb) {
        return this.mViewBinderManager.addViewBinder(cvb);
    }

    protected synchronized boolean removeViewBinder(int viewType) {
        return this.mViewBinderManager.removeViewBinder(viewType);
    }

    public synchronized boolean existViewBinder(ViewBinder viewBinder) {
        return this.mViewBinderManager.existViewBinder(viewBinder);
    }

    public synchronized void addFirstCollection(List<T> collection) {
        RecyclerViewUtils.checkNotNull(collection, "Collection to add on the DataSet is null.");
        int targetSize = collection.size();
        int insertPos = this.registeredHeaderView() ? 1 : 0;
        this.mDataSet.addAll(insertPos, collection);
        this.notifyItemRangeInserted(-targetSize, targetSize);
    }

    public synchronized void addLastCollection(List<T> collection) {
        RecyclerViewUtils.checkNotNull(collection, "Collection to add on the DataSet is null.");
        int targetSize = collection.size();
        int insertPos = this.getItemCount();
        if (this.registeredFooterView()) {
            if (this.getItemCount() == 1) {
                insertPos = 0;
            } else if (this.getItemCount() > 1) {
                insertPos = this.getItemCount() - 1;
            }
        }
        this.mDataSet.addAll(insertPos, collection);
        this.notifyItemRangeInserted(insertPos + 1, targetSize);
    }

    public synchronized void addLast(T object) {
        if (!this.registeredFooterView()) {
            int insertionPos = this.getItemCount();
            this.mDataSet.add(insertionPos, object);
            this.notifyItemInserted(insertionPos);
            return;
        }
        int insertionPos = this.getItemCount() == 0 ? 0 : this.getItemCount() - 1;
        this.mDataSet.add(insertionPos, object);
        this.notifyItemInserted(insertionPos);
    }

    public synchronized void addFirst(T object) {
        if (!this.registeredHeaderView()) {
            this.mDataSet.add(0, object);
            this.notifyItemInserted(0);
            return;
        }
        int insertionPos = this.getItemCount() == 0 ? 0 : 1;
        this.mDataSet.add(insertionPos, object);
        this.notifyItemInserted(insertionPos);
    }

    public synchronized void addPosition(T object, int position) {
        this.mDataSet.add(position, object);
        this.notifyItemInserted(position);
    }

    public synchronized void removeLastItem() {
        if (this.getItemCount() == 0) {
            return;
        }
        int removeItemPos = this.getItemCount() - 1;
        this.mDataSet.remove(removeItemPos);
        this.notifyItemRemoved(removeItemPos);
    }

    public synchronized void removeFirstItem() {
        if (this.getItemCount() == 0) {
            return;
        }
        this.mDataSet.remove(0);
        this.notifyItemRemoved(0);
    }

    public synchronized void updatePositionWithNotify(T object, int position) {
        this.updatePosition(object, position);
        this.notifyItemChanged(position);
    }

    public synchronized void updatePosition(T object, int position) {
        this.mDataSet.set(position, object);
    }

    public synchronized void clearDataSet() {
        int size = this.getItemCount();
        this.mDataSet.clear();
        this.notifyItemRangeRemoved(0, size);
    }

    protected void removeFooterItem() {
        if (!this.registeredFooterView()) {
            throw new IllegalArgumentException("Adapter is not using the footer view");
        }
        if (this.getItemCount() == 0) {
            throw new IndexOutOfBoundsException("There is no items in the DataSet");
        }
        if (!(this.mDataSet.get(this.getItemCount() - 1) instanceof RecyclerViewFooterItem)) {
            throw new RuntimeException("The last item of the DataSet MUST be an instance of RecyclerViewFooterItem");
        }
        this.removeLastItem();
    }

    protected void removeHeaderItem() {
        if (!this.registeredHeaderView()) {
            throw new IllegalArgumentException("Adapter is not using the header view");
        }
        if (this.getItemCount() == 0) {
            throw new IndexOutOfBoundsException("There is no items in the DataSet");
        }
        if (!(this.mDataSet.get(0) instanceof RecyclerViewHeaderItem)) {
            throw new RuntimeException("The first item of the DataSet MUST be an instance of RecyclerViewHeaderItem");
        }
        this.removeFirstItem();
    }

    public synchronized void setData(int position, T object) {
        if (this.getItemCount() <= position) {
            throw new IllegalArgumentException("Position is invalid");
        }
        this.mDataSet.set(position, object);
        this.notifyItemChanged(position);
    }
}

