/*
 * Decompiled with CFR 0.152.
 */
package kr.seongil.recyclerview.listener;

import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import kr.seongil.recyclerview.utils.RecyclerViewUtils;
import kr.seongil.recyclerview.viewadapter.RecyclerListViewListener;

public class RecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private static final String TAG = "SmartRecyclerView";
    private static final String LOG_PREFIX = RecyclerViewUtils.getPrefix("RecyclerViewScrollListener");
    private static final int CNT_OF_MINIMUM_LOADED_ITEMS = 20;
    private LinearLayoutManager mLinearLayoutManager;
    private RecyclerListViewListener mRecyclerListViewListener;
    private final int mLoadingItemsThreshold;
    private int mCntOfPrevTotalItem;
    private int mPosOfFirstVisibleItem;
    private int mCntOfVisibleItem;
    private int mCntOfTotalItem;

    public RecyclerViewScrollListener(@NonNull LinearLayoutManager llm, @NonNull RecyclerListViewListener recyclerListViewListener, int loadingThreshold) {
        this.mLinearLayoutManager = llm;
        this.mRecyclerListViewListener = recyclerListViewListener;
        if (loadingThreshold <= 0) {
            throw new IllegalArgumentException("Threshold is invalid. You must pass it greater than 0.");
        }
        this.mLoadingItemsThreshold = loadingThreshold;
        this.initScrollListener();
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        Direction scrollDirection = this.decideScrollDirection(dx, dy);
        this.mCntOfVisibleItem = recyclerView.getChildCount();
        this.mCntOfTotalItem = this.mLinearLayoutManager.getItemCount();
        this.mPosOfFirstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        if (scrollDirection == Direction.UP || scrollDirection == Direction.LEFT) {
            this.handleScrollUp();
        } else if (scrollDirection == Direction.DOWN || scrollDirection == Direction.RIGHT) {
            this.handleScrollDown();
        } else if (scrollDirection == Direction.STOP) {
            this.loadItemsMoreForcibly();
        } else {
            throw new IllegalArgumentException("Undefined scrolling direction.");
        }
    }

    public void initScrollListener() {
        this.mCntOfPrevTotalItem = 0;
        this.mPosOfFirstVisibleItem = 0;
        this.mCntOfVisibleItem = 0;
        this.mCntOfTotalItem = 0;
    }

    public void loadItemsMoreForcibly() {
        if (this.mCntOfTotalItem >= 20) {
            return;
        }
        if (this.mRecyclerListViewListener.registeredHeaderView()) {
            this.onLoadPrevData();
        }
        if (this.mRecyclerListViewListener.registeredFooterView()) {
            this.onLoadNextData();
        }
        Log.d((String)TAG, (String)(LOG_PREFIX + "The count of items in LayoutManager is " + this.mCntOfTotalItem + ". So we are need to load more data forcibly."));
    }

    protected boolean isLoadingNextItems() {
        return false;
    }

    protected boolean isLoadingPrevItems() {
        return false;
    }

    public void onLoadNextData() {
    }

    public void onLoadPrevData() {
    }

    private void handleScrollDown() {
        if (!this.isLoadingPrevItems() && this.mRecyclerListViewListener.loadHeaderItemsMore() && this.mPosOfFirstVisibleItem <= this.mLoadingItemsThreshold) {
            this.onLoadPrevData();
        }
    }

    private void handleScrollUp() {
        if (this.isLoadingNextItems() && this.mCntOfTotalItem > this.mCntOfPrevTotalItem) {
            this.mCntOfPrevTotalItem = this.mCntOfTotalItem;
        }
        if (!this.isLoadingNextItems() && this.mRecyclerListViewListener.loadFooterItemsMore() && this.mCntOfTotalItem - this.mCntOfVisibleItem <= this.mPosOfFirstVisibleItem + this.mLoadingItemsThreshold) {
            this.onLoadNextData();
        }
    }

    private Direction decideScrollDirection(int dx, int dy) {
        if (dx > 0) {
            return Direction.RIGHT;
        }
        if (dx < 0) {
            return Direction.LEFT;
        }
        if (dy > 0) {
            return Direction.UP;
        }
        if (dy < 0) {
            return Direction.DOWN;
        }
        return Direction.STOP;
    }

    private static enum Direction {
        STOP,
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }
}

