/*
 * Copyright 2015 Kim Seong-il
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kr.seongil.recyclerview.viewbinder;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;

import java.util.List;

/**
 * I refer to follow project and customized it.
 * https://github.com/sockeqwe/AdapterDelegates/
 * This ViewBinder provide method to hook in this ViewBinder to {@link RecyclerView.Adapter} lifecycle.
 * This "hook in" mechanism is provided by {@link ViewBinderListManager} and that is the component you have to use.
 *
 * @author Kim Seong-il
 * @since 1.0.0
 */
public interface ViewBinder<T extends List> {

    int getItemViewType();

    boolean isForViewType(@NonNull T dataSet, int position);

    @NonNull
    RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent);

    void onBindViewHolder(@NonNull T items, int position, @NonNull RecyclerView.ViewHolder holder);
}