/*
 * Copyright 2015 Kim Seong-il
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kr.seongil.recyclerview.listener;

import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;

import kr.seongil.recyclerview.viewadapter.RecyclerListViewAdapter;

/**
 * @author Kim Seong-il
 * @since 1.0.0
 */
public class LinearRecyclerViewScrollListener extends RecyclerViewScrollListener {

    // ===========================================================
    // Constants
    // ===========================================================
    private static final int LOAD_ITEMS_THRESHOLD = 5;

    // ===========================================================
    // Fields
    // ===========================================================

    // ===========================================================
    // Constructors
    // ===========================================================
    public LinearRecyclerViewScrollListener(
            @NonNull final LinearLayoutManager llm,
            @NonNull final RecyclerListViewAdapter recyclerListViewListener) {
        this(llm, recyclerListViewListener, LOAD_ITEMS_THRESHOLD);
    }

    public LinearRecyclerViewScrollListener(
            @NonNull final LinearLayoutManager llm,
            @NonNull final RecyclerListViewAdapter recyclerListViewListener,
            final int loadItemsThreshold) {
        super(llm, recyclerListViewListener, loadItemsThreshold);
    }

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Listeners
    // ===========================================================

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
}
