/*
 * Copyright 2015 Kim Seong-il
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kr.seongil.recyclerview.listener;

import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;

import kr.seongil.recyclerview.viewadapter.RecyclerListViewListener;
import kr.seongil.recyclerview.viewbinder.AbstractViewBinder;

/**
 * @author Kim Seong-il
 * @since 1.0.0
 */
public class GridRecyclerViewScrollListener extends RecyclerViewScrollListener {

    // ===========================================================
    // Constants
    // ===========================================================
    private static final int LOAD_ITEMS_THRESHOLD = 5;

    // ===========================================================
    // Fields
    // ===========================================================

    // ===========================================================
    // Constructors
    // ===========================================================
    public GridRecyclerViewScrollListener(@NonNull final GridLayoutManager glm, final RecyclerListViewListener recyclerListViewListener) {
        this(glm, recyclerListViewListener, LOAD_ITEMS_THRESHOLD * glm.getSpanCount());
    }

    public GridRecyclerViewScrollListener(@NonNull final GridLayoutManager glm,
                                          @NonNull final RecyclerListViewListener recyclerListViewListener,
                                          final int loadItemsThreshold) {
        super(glm, recyclerListViewListener, loadItemsThreshold);
        glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {

            @Override
            public int getSpanSize(int position) {
                if (recyclerListViewListener.getItemViewType(position) == AbstractViewBinder.RECYCLER_HEADER_VIEW_TYPE) {
                    return glm.getSpanCount();
                }
                if (recyclerListViewListener.getItemViewType(position) == AbstractViewBinder.RECYCLER_FOOTER_VIEW_TYPE) {
                    return glm.getSpanCount();
                }
                return 1;
            }
        });
    }

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    // ===========================================================
    // Methods
    // ===========================================================
}
