//                            _ooOoo_  
//                           o8888888o  
//                           88" . "88  
//                           (| -_- |)  
//                            O\ = /O  
//                        ____/`---'\____  
//                      .   ' \\| |// `.  
//                       / \\||| : |||// \  
//                     / _||||| -:- |||||- \  
//                       | | \\\ - /// | |  
//                     | \_| ''\---/'' | |  
//                      \ .-\__ `-` ___/-. /  
//                   ___`. .' /--.--\ `. . __  
//                ."" '< `.___\_<|>_/___.' >'"".  
//               | | : `- \`.;`\ _ /`;.`/ - ` : | |  
//                 \ \ `-. \_ __\ /__ _/ .-` / /  
//         ======`-.____`-.___\_____/___.-`____.-'======  
//                            `=---='  
//  
//         .............................................  
//                  汣             BUG 
//          Ի:  
//                  д¥дּ䣬дּԱ  
//                  Աдó򻻾Ǯ  
//                  ֻߣ  
//                  ոգ긴ꡣ  
//                  ԸԼ䣬ԸϹϰǰ  
//                  ۱ȤгԱ  
//                  Ц߯񲣬ЦԼ̫  
//                  ƯãĸóԱ  
/************************************************************/
//  ʹ˵introduction
//  Ϊ ؼ    Ӳ֣ Ӳ  5.0
//  ֪   Ӳ Ҫ  enableclickable
//  Ҫ ִ ƺ ִУ ʵ OnRippleCompleteListener   
//  eg:
//	RevealLayout findViewById = (RevealLayout) findViewById(R.id.layout1);
//		findViewById.setOnRippleCompleteListener(new OnRippleCompleteListener() {

//			@Override
//			public void onComplete() {
//				Intent  intent=new Intent(MainActivity.this, MainActivity.class);
//				startActivity(intent);

//			}
//		});
/************************************************************/
package com.jorge.ripple_effect;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;

import java.util.ArrayList;

public class RippleLayout extends LinearLayout {
    private Paint mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    // Բ  x,y
    private float mCenterX, mCenterY;
    // 뾶
    private int mRevealRadius = 0;
    private int[] mLocation = new int[2];
    private int INVALIDATE_DURATION = 4;
    // Ŀ   ߶
    private int mTargetHeight, mTargetWidth;
    // Բ뾶
    public int mMaxRadius;
    // 뾶ӷ
    private int mRevealRadiusGap;
    // ؼ
    private int mMinBetweenWidthAndHeight;
    // Ƿ״̬
    private boolean mIsPressed;
    // ǷҪ
    private boolean mShouldDoAnimation;
    // ǰҪƵ view
    private View mTargetView;
    //ָ̧ ͬһView 档
    private boolean onOneView=true;
    public RippleLayout(Context context) {
        super(context);
        init();
    }

    public RippleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }
    // Android 3.0
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    public RippleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    public void init() {
//		 Debug.startMethodTracing("Love_World_");  
        // onDraw ִ
//		setWillNotDraw(false);
        // ûɫ
        mPaint.setColor(getResources().getColor(R.color.reveal_color));
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.getLocationOnScreen(mLocation);
    }

    /**
     *  view
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        // Ŀview   Լ ȡ
        if (mTargetView == null || !mShouldDoAnimation || mTargetWidth <= 0)
            return;
        //  Բĵǰ뾶  ť  ߸߶ȵ 1/2  뾶ӷȱ
        if (mRevealRadius > mMinBetweenWidthAndHeight /4)
            mRevealRadius += mRevealRadiusGap * 4;
        else
            mRevealRadius += mRevealRadiusGap;
        int[] location = new int[2];
        this.getLocationOnScreen(mLocation);
        mTargetView.getLocationOnScreen(location);
        // 㵱ǰĿview  l t r b
        int top = location[1] - mLocation[1];
        int left = location[0] - mLocation[0];
        int right = left + mTargetView.getMeasuredWidth();
        int bottom = top + mTargetView.getMeasuredHeight();
        canvas.save();
        // û 㣨left,top mTargetView.getMeasuredWidth()߶
        // mTargetView.getMeasuredHeight()
        canvas.clipRect(left, top, right, bottom);
        // Բ ԲģmCenterXmCenterY 뾶 mRevealRadius  mPaint
        canvas.drawCircle(mCenterX, mCenterY, mRevealRadius, mPaint);
        // ָԭ״̬
        canvas.restore();
//		canvas.drawLine(startX, startY, stopX, stopY, paint)
        // ǰ뾶 ûг 뾶 ʾ ûиbutton Ҫ Լ
        if (mRevealRadius <= mMaxRadius) {
            postInvalidateDelayed(INVALIDATE_DURATION, left, top, right, bottom);
        } else if (!mIsPressed) {
            //  ʱִУ  button ָԭ
            mShouldDoAnimation = false;
            postInvalidateDelayed(INVALIDATE_DURATION, left, top, right, bottom);
            //  ʵ ¼Чbutton ˢɺִ
            if (onCompletionListener != null&&onOneView)
                onCompletionListener.onComplete(mTargetView.getId());

        }

    }

    // touch¼ַ
    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        int x = (int) event.getRawX();
        int y = (int) event.getRawY();
        int action = event.getAction();
        switch (action) {
            case MotionEvent.ACTION_DOWN:

                //ָµλãȷĸView
                targetView = getTargetView(this, x, y);
//			System.out.println("targetView:"+targetView.toString());
                if (targetView != null && targetView.isEnabled()) {
                    mTargetView = targetView;
                    initParametersForChild(event, targetView);
                    postInvalidateDelayed(INVALIDATE_DURATION);
                }
                break;
            case MotionEvent.ACTION_UP:
                //жְº̧ͬһView
                viewOnScreen(event, this,x,y);
                mIsPressed = false;
                postInvalidateDelayed(INVALIDATE_DURATION);
                break;
            case MotionEvent.ACTION_CANCEL:
                mIsPressed = false;
                postInvalidateDelayed(INVALIDATE_DURATION);
                break;
        }
        return super.dispatchTouchEvent(event);
    }

    /**
     * ݴ   view
     *
     * @param view
     * @param x
     * @param y
     * @return
     */
    public View getTargetView(View view, int x, int y) {
        View target = null;
        ArrayList<View> views = view.getTouchables();
        System.out.println("view:"+views.size());
        for (View child : views)

            if (isTouchPointInView(child, x, y)) {
                target = child;
                break;
            }
//		System.out.println("child:"+child.toString());
        return target;
    }

    /**
     *  x y  Ƿ  child view ķΧ
     *
     * @param child
     * @param x
     * @param y
     * @return
     */
    public boolean isTouchPointInView(View child, int x, int y) {
        int[] location = new int[2];
        child.getLocationOnScreen(location);
        int top = location[1];
        int left = location[0];
        int right = left + child.getMeasuredWidth();
        int bottom = top + child.getMeasuredHeight();

        if (child.isClickable() && y >= top && y <= bottom && x >= left && x <= right)
            return true;
        else
            return false;
    }

    /**
     * ʼview 
     *
     * @param event
     * @param view
     */
    public void initParametersForChild(MotionEvent event, View view) {
        // ָ x ,y Ļе 
        mCenterX = event.getX();
        mCenterY = event.getY();

        // ֻ view  
        mTargetWidth = view.getMeasuredWidth();
        // ֻ view  ߶
        mTargetHeight = view.getMeasuredHeight();
        // ж  ͸߶ ǸֵȽϴ
        mMinBetweenWidthAndHeight = Math.min(mTargetWidth, mTargetHeight);
        mRevealRadius = 0;
        mRevealRadiusGap = mMinBetweenWidthAndHeight / 8;
        mIsPressed = true;
        mShouldDoAnimation = true;
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0] - mLocation[0];
        int top = location[1] - mLocation[1];
        // view ߽Ŀ
        int mTransformedCenterX = (int) mCenterX - left;
        // view 붥ľ
        int transformedCenterY = (int) mCenterY - top;
        //  view   ͸߶ ȡ Բ 뾶
        int maxX = Math.max(mTransformedCenterX, mTargetWidth - mTransformedCenterX);
        int maxY = Math.max(transformedCenterY, mTargetHeight - transformedCenterY);
        mMaxRadius = Math.max(maxX, maxY);

    }

    // ɺ 
    private OnRippleCompleteListener onCompletionListener;

    private View targetView;

    public void setOnRippleCompleteListener(OnRippleCompleteListener listener) {
        this.onCompletionListener = listener;
    }

    /**
     * Defines a callback called at the end of the Ripple effect
     */
    public interface OnRippleCompleteListener {
        void onComplete(int id);
    }

    /**
     * ж̧ǲͬһView
     * @param event  ָ̧
     * @param view   ̧view
     */
    public void viewOnScreen(MotionEvent event, View view,int x,int y){
        View upView = getTargetView(view, x, (int)y);

        if(targetView.equals(upView)&&(null!=upView)&&(targetView.getId()==upView.getId())){
            onOneView=true;
        }else{
            onOneView=false;
        }
    }
}
