/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.PingppException;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.HttpContent;
import com.pingplusplus.net.HttpHeaders;
import com.pingplusplus.net.RequestOptions;
import com.pingplusplus.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PingppRequest {
    APIResource.RequestMethod method;
    URL url;
    HttpContent content;
    HttpHeaders headers;
    Map<String, Object> params;
    RequestOptions options;

    public PingppRequest(APIResource.RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws PingppException {
        try {
            this.params = params != null ? Collections.unmodifiableMap(params) : null;
            this.options = options != null ? options : RequestOptions.getDefault();
            this.method = method;
            this.url = PingppRequest.buildURL(method, url, params, this.options);
            this.content = PingppRequest.buildContent(method, params);
            this.headers = PingppRequest.buildHeaders(method, this.options);
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again.", Pingpp.getApiBase(), e.getMessage()), e);
        }
    }

    private static URL buildURL(APIResource.RequestMethod method, String spec, Map<String, Object> params, RequestOptions options) throws IOException, InvalidRequestException {
        String queryString;
        StringBuilder sb = new StringBuilder();
        if (spec.contains("<APP_ID>")) {
            if (options.getAppId() == null) {
                throw new InvalidRequestException("Please set app_id using Pingpp.appId = <APP_ID> or ReqquestOptions", "invalid_request_error", "request_param_error", "app_id", 0, null);
            }
            spec = spec.replaceFirst("<APP_ID>", options.getAppId());
        }
        sb.append(spec);
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT && params != null && !(queryString = PingppRequest.createQuery(params)).isEmpty()) {
            sb.append("?");
            sb.append(queryString);
        }
        return new URL(sb.toString());
    }

    private static HttpContent buildContent(APIResource.RequestMethod method, Map<String, Object> params) {
        if (method != APIResource.RequestMethod.POST && method != APIResource.RequestMethod.PUT) {
            return null;
        }
        if (params == null) {
            return null;
        }
        return HttpContent.buildJSONContent(params);
    }

    private static String createQuery(Map<String, Object> params) {
        if (params == null) {
            return "";
        }
        Map<String, String> flatParams = PingppRequest.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(PingppRequest.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String urlEncodePair(String k, String v) {
        return String.format("%s=%s", PingppRequest.urlEncode(k), PingppRequest.urlEncode(v));
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(PingppRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(PingppRequest.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static HttpHeaders buildHeaders(APIResource.RequestMethod method, RequestOptions options) throws AuthenticationException {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Accept", Collections.singletonList("application/json"));
        headerMap.put("Accept-Charset", Collections.singletonList(APIResource.CHARSET.name()));
        headerMap.put("Accept-Language", Collections.singletonList(options.getAcceptLanguage()));
        String apiKey = options.getApiKey();
        if (apiKey == null) {
            throw new AuthenticationException("No API key provided. Set your API key using `Pingpp.apiKey = \"<API-KEY>\"`.");
        }
        if (apiKey.isEmpty()) {
            throw new AuthenticationException("Your API key is invalid, as it is an empty string.");
        }
        if (StringUtils.containsWhitespace(apiKey)) {
            throw new AuthenticationException("Your API key is invalid, as it contains whitespace.");
        }
        headerMap.put("Authorization", Collections.singletonList(String.format("Bearer %s", apiKey)));
        return HttpHeaders.of(headerMap);
    }

    public APIResource.RequestMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public RequestOptions getOptions() {
        return this.options;
    }
}

