/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.pingplusplus.model.BatchRefund;
import com.pingplusplus.model.BatchTransfer;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.Customs;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.Refund;
import com.pingplusplus.model.Summary;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.APIResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static final Map<String, Class> objectMap = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ".");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if (!"object".equals(key)) continue;
                String type = element.getAsJsonObject().get("object").getAsString();
                Class<PingppRawJsonObject> cl = objectMap.get(type);
                PingppObject object = (PingppObject)APIResource.getGson().fromJson((JsonElement)entry.getValue(), cl != null ? cl : PingppRawJsonObject.class);
                eventData.setObject(object);
            }
        }
        return eventData;
    }

    static {
        objectMap.put("charge", Charge.class);
        objectMap.put("transfer", Transfer.class);
        objectMap.put("refund", Refund.class);
        objectMap.put("red_envelope", RedEnvelope.class);
        objectMap.put("account_daily_summary", Summary.class);
        objectMap.put("account_weekly_summary", Summary.class);
        objectMap.put("account_monthly_summary", Summary.class);
        objectMap.put("app_monthly_summary", Summary.class);
        objectMap.put("app_daily_summary", Summary.class);
        objectMap.put("app_weekly_summary", Summary.class);
        objectMap.put("batch_transfer", BatchTransfer.class);
        objectMap.put("batch_refund", BatchRefund.class);
        objectMap.put("customs", Customs.class);
    }
}

