/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.model;

import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeCollection;
import com.pingplusplus.model.ChargeEssentials;
import com.pingplusplus.model.OrderCollection;
import com.pingplusplus.net.APIResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Order
extends APIResource {
    String id;
    String object;
    Long created;
    Boolean livemode;
    String status;
    Boolean paid;
    Boolean refunded;
    Object app;
    String charge;
    String uid;
    String merchantOrderNo;
    Integer amount;
    Integer couponAmount;
    Integer actualAmount;
    Integer amountRefunded;
    Integer amountPaid;
    String currency;
    String subject;
    String body;
    String clientIp;
    Long timePaid;
    Long timeExpire;
    String coupon;
    ChargeCollection charges;
    String description;
    Map<String, Object> metadata;
    ChargeEssentials chargeEssentials;
    Long availableBalance;
    String userFrom;
    String receiptApp;
    String serviceApp;
    List<String> availableMethods;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String string) {
        this.object = string;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long l) {
        this.created = l;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean bl) {
        this.livemode = bl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean bl) {
        this.paid = bl;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean bl) {
        this.refunded = bl;
    }

    public Object getApp() {
        return this.app;
    }

    public void setApp(Object object) {
        this.app = object;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getMerchantOrderNo() {
        return this.merchantOrderNo;
    }

    public void setMerchantOrderNo(String string) {
        this.merchantOrderNo = string;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer n) {
        this.amount = n;
    }

    public Integer getCouponAmount() {
        return this.couponAmount;
    }

    public void setCouponAmount(Integer n) {
        this.couponAmount = n;
    }

    public Integer getActualAmount() {
        return this.actualAmount;
    }

    public void setActualAmount(Integer n) {
        this.actualAmount = n;
    }

    public Integer getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Integer n) {
        this.amountRefunded = n;
    }

    public Integer getAmountPaid() {
        return this.amountPaid;
    }

    public void setAmountPaid(Integer n) {
        this.amountPaid = n;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String string) {
        this.currency = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String string) {
        this.clientIp = string;
    }

    public Long getTimePaid() {
        return this.timePaid;
    }

    public void setTimePaid(Long l) {
        this.timePaid = l;
    }

    public Long getTimeExpire() {
        return this.timeExpire;
    }

    public void setTimeExpire(Long l) {
        this.timeExpire = l;
    }

    public String getCoupon() {
        return this.coupon;
    }

    public void setCoupon(String string) {
        this.coupon = string;
    }

    public ChargeCollection getCharges() {
        return this.charges;
    }

    public void setCharges(ChargeCollection chargeCollection) {
        this.charges = chargeCollection;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> map) {
        this.metadata = map;
    }

    public ChargeEssentials getChargeEssentials() {
        return this.chargeEssentials;
    }

    public void setChargeEssentials(ChargeEssentials chargeEssentials) {
        this.chargeEssentials = chargeEssentials;
    }

    public Long getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(Long l) {
        this.availableBalance = l;
    }

    public String getUserFrom() {
        return this.userFrom;
    }

    public void setUserFrom(String string) {
        this.userFrom = string;
    }

    public String getReceiptApp() {
        return this.receiptApp;
    }

    public void setReceiptApp(String string) {
        this.receiptApp = string;
    }

    public String getServiceApp() {
        return this.serviceApp;
    }

    public void setServiceApp(String string) {
        this.serviceApp = string;
    }

    public List<String> getAvailableMethods() {
        return this.availableMethods;
    }

    public void setAvailableMethods(List<String> list) {
        this.availableMethods = list;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String string) {
        this.charge = string;
    }

    public static Order create(Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.POST, Order.classURL(Order.class), map, Order.class);
    }

    public static Order retrieve(String string) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.GET, Order.instanceURL(Order.class, string), null, Order.class);
    }

    public static OrderCollection list(Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.GET, Order.classURL(Order.class), map, OrderCollection.class);
    }

    public static Order update(String string, Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.PUT, Order.instanceURL(Order.class, string), map, Order.class);
    }

    public Order cancel() throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("status", "canceled");
        return Order.update(this.getId(), hashMap);
    }

    public static Order cancel(String string) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("status", "canceled");
        return Order.update(string, hashMap);
    }

    public Order pay(Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.POST, String.format("%s/pay", Order.instanceURL(Order.class, this.id)), map, Order.class);
    }

    public static Order pay(String string, Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.POST, String.format("%s/pay", Order.instanceURL(Order.class, string)), map, Order.class);
    }

    public static ChargeCollection chargeList(String string, Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.GET, String.format("%s/charges", Order.instanceURL(Order.class, string)), map, ChargeCollection.class);
    }

    public static Charge retrieveCharge(String string, String string2) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return Order.request(APIResource.RequestMethod.GET, String.format("%s/charges/%s", Order.instanceURL(Order.class, string), string2), null, Charge.class);
    }
}

