/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pingplusplus.PingppAccount;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.BatchRefundCharges;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeEssentials;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.CouponTemplateExpiration;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.SettleAccountRecipient;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.serializer.AccountEventDataDeserializer;
import com.pingplusplus.serializer.BatchRefundChargesSerializer;
import com.pingplusplus.serializer.BatchTransferRecipientSerializer;
import com.pingplusplus.serializer.ChargeDeserializer;
import com.pingplusplus.serializer.ChargeEssentialsSerializer;
import com.pingplusplus.serializer.ChargeRefundCollectionDeserializer;
import com.pingplusplus.serializer.CouponTemplateExpirationSerializer;
import com.pingplusplus.serializer.DoubleTypeSerializer;
import com.pingplusplus.serializer.PingppRawJsonObjectDeserializer;
import com.pingplusplus.serializer.RedEnvelopeDeserializer;
import com.pingplusplus.serializer.SettleAccountRecipientSerializer;
import com.pingplusplus.serializer.TransferDeserializer;
import java.io.UnsupportedEncodingException;

public abstract class AppBasedResource
extends APIResource {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(EventData.class, (Object)new AccountEventDataDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).create();
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).disableHtmlEscaping().registerTypeAdapter(BatchTransferRecipientSerializer.class, (Object)new BatchTransferRecipientSerializer()).registerTypeAdapter(BatchRefundCharges.class, (Object)new BatchRefundChargesSerializer()).registerTypeAdapter(Double.class, (Object)new DoubleTypeSerializer()).registerTypeAdapter(ChargeEssentials.class, (Object)new ChargeEssentialsSerializer()).registerTypeAdapter(CouponTemplateExpiration.class, (Object)new CouponTemplateExpirationSerializer()).registerTypeAdapter(SettleAccountRecipient.class, (Object)new SettleAccountRecipientSerializer()).create();

    protected static String className(Class<?> clazz) {
        String string = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (string.equals("assettransaction")) {
            return "asset_transaction";
        }
        if (string.equals("balancebonus")) {
            return "balance_bonuse";
        }
        if (string.equals("balancetransfer")) {
            return "balance_transfer";
        }
        if (string.equals("balancetransaction")) {
            return "balance_transaction";
        }
        if (string.equals("coupontemplate")) {
            return "coupon_template";
        }
        if (string.equals("batchwithdrawal")) {
            return "batch_withdrawal";
        }
        if (string.equals("transactionstatistics")) {
            return "transaction_statistics";
        }
        if (string.equals("settleaccount")) {
            return "settle_account";
        }
        if (string.equals("subapp")) {
            return "sub_app";
        }
        if (string.equals("royalty")) {
            return "royaltie";
        }
        if (string.equals("royaltysettlement")) {
            return "royalty_settlement";
        }
        if (string.equals("royaltytransaction")) {
            return "royalty_transaction";
        }
        return string;
    }

    protected static String singleClassURL(Class<?> clazz) throws InvalidRequestException {
        if (PingppAccount.appId == null) {
            throw new InvalidRequestException("Please set app_id using PingppAccount.appId = <APP_ID>", "app_id", null);
        }
        return String.format("%s/v1/apps/%s/%s", PingppAccount.getApiBase(), PingppAccount.appId, AppBasedResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) throws InvalidRequestException {
        return String.format("%ss", AppBasedResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String string) throws InvalidRequestException {
        try {
            return String.format("%s/%s", AppBasedResource.classURL(clazz), AppBasedResource.urlEncode(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, unsupportedEncodingException);
        }
    }

    protected static String customURL(String string) throws InvalidRequestException {
        if (PingppAccount.appId == null) {
            throw new InvalidRequestException("Please set app_id using PingppAccount.appId = <APP_ID>", "app_id", null);
        }
        return String.format("%s/v1/apps/%s/%s", PingppAccount.getApiBase(), PingppAccount.appId, string);
    }
}

