/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.model;

import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.CardCollection;
import com.pingplusplus.model.Customer;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.DeleteResult;
import java.util.Map;

public class Card
extends APIResource {
    private String id;
    private String object;
    private Long timestamp;
    private String last4;
    private String funding;
    private String brand;
    private String bank;
    private String customer;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getLast4() {
        return this.last4;
    }

    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public String getFunding() {
        return this.funding;
    }

    public void setFunding(String funding) {
        this.funding = funding;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public static Card create(String customerId, Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        String url = Card.instanceURL(Customer.class, customerId) + "/sources";
        return Card.request(APIResource.RequestMethod.POST, url, params, Card.class);
    }

    public static DeleteResult delete(String customerId, String id) throws ChannelException, APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        String url = Card.instanceURL(Customer.class, customerId) + "/sources/" + id;
        return Card.request(APIResource.RequestMethod.DELETE, url, null, DeleteResult.class);
    }

    public static Card retrieve(String customerId, String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        String url = Card.instanceURL(Customer.class, customerId) + "/sources/" + id;
        return Card.request(APIResource.RequestMethod.GET, url, null, Card.class);
    }

    public static CardCollection all(String customerId, Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        String url = Card.instanceURL(Customer.class, customerId) + "/sources";
        return Card.request(APIResource.RequestMethod.GET, url, params, CardCollection.class);
    }
}

