/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeDeserializer;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.ChargeRefundCollectionDeserializer;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.PingppRawJsonObjectDeserializer;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.RedEnvelopeDeserializer;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.model.TransferDeserializer;
import com.pingplusplus.net.PingppResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public abstract class APIResource
extends PingppObject {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).create();
    public static final String CHARSET = "UTF-8";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.pingplusplus.net.customURLStreamHandler";

    private static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (className.equals("redenvelope")) {
            return "red_envelope";
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/v1/%s", Pingpp.getApiBase(), APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@pingxx.com for assistance.", null, e);
        }
    }

    private static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", APIResource.urlEncode(k), APIResource.urlEncode(v));
    }

    static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("Pingpp/v1 JavaBindings/%s", "2.0.8"));
        if (apiKey == null) {
            apiKey = Pingpp.apiKey;
        }
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        headers.put("Accept-Language", Pingpp.AcceptLanguage);
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "2.0.8");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Pingpp");
        headers.put("X-Pingpp-Client-User-Agent", GSON.toJson(propertyMap));
        if (Pingpp.apiVersion != null) {
            headers.put("Pingplusplus-Version", Pingpp.apiVersion);
        }
        return headers;
    }

    private static HttpURLConnection createPingppConnection(String url, String apiKey) throws IOException {
        URL pingppURL = null;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                pingppURL = new URL(null, url, customHandler);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        } else {
            pingppURL = new URL(url);
        }
        HttpsURLConnection conn = (HttpsURLConnection)pingppURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : APIResource.getHeaders(apiKey).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static void throwInvalidCertificateException() throws APIConnectionException {
        throw new APIConnectionException("Invalid server certificate. You tried to connect to a server that has a revoked SSL certificate, which means we cannot securely send data to that server. Please email support@pingxx.com if you need help connecting to the correct API server.");
    }

    private static void checkSSLCert(HttpURLConnection hconn) throws IOException, APIConnectionException {
        if (!Pingpp.getVerifySSL() && !hconn.getURL().getHost().equals("api.pingxx.com")) {
            return;
        }
        HttpsURLConnection conn = (HttpsURLConnection)hconn;
        conn.connect();
        Certificate[] certs = conn.getServerCertificates();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certs[0].getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            byte[] revokedCertDigest = new byte[]{5, -64, -77, 100, 54, -108, 71, 10, -120, -116, 110, 127, -21, 92, -98, 36, -24, 35, -36, 83};
            if (Arrays.equals(digest, revokedCertDigest)) {
                APIResource.throwInvalidCertificateException();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateEncodingException e) {
            APIResource.throwInvalidCertificateException();
        }
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String getURL = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createPingppConnection(getURL, apiKey);
        conn.setRequestMethod("GET");
        APIResource.checkSSLCert(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = APIResource.createPingppConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        APIResource.checkSSLCert(conn);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private static HttpURLConnection createDeleteConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String deleteUrl = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createPingppConnection(deleteUrl, apiKey);
        conn.setRequestMethod("DELETE");
        APIResource.checkSSLCert(conn);
        return conn;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> flatParams = APIResource.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + key + "' to an empty string. " + "We interpret empty strings as null in requests. " + "You may set '" + key + "' to null to delete the property.", key, null);
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static PingppResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = APIResource.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = APIResource.createPostConnection(url, query, apiKey);
                    break;
                }
                case DELETE: {
                    conn = APIResource.createDeleteConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Pingpp bindings. Please contact support@pingxx.com for assistance.", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode >= 200 && rCode < 300 ? APIResource.getResponseBody(conn.getInputStream()) : APIResource.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            PingppResponse pingppResponse = new PingppResponse(rCode, rBody, headers);
            return pingppResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again. If this problem persists,you should check Pingpp's service status at https://pingxx.com, or let us know at support@pingxx.com.", Pingpp.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            T t = APIResource._request(method, url, params, clazz, apiKey);
            return t;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    protected static <T> T _request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        PingppResponse response;
        String query;
        if (!(Pingpp.apiKey != null && Pingpp.apiKey.length() != 0 || apiKey != null && apiKey.length() != 0)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Pingpp.apiKey = <API-KEY>'. You can generate API keys from the Pingpp web interface. See https://pingxx.com for details or email support@pingxx.com if you have questions.");
        }
        if (apiKey == null) {
            apiKey = Pingpp.apiKey;
        }
        try {
            query = APIResource.createQuery(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@pingxx.com for assistance.", null, e);
        }
        try {
            response = APIResource.makeURLConnectionRequest(method, url, query, apiKey);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                response = APIResource.makeAppEngineRequest(method, url, query, apiKey);
            }
            throw ce;
        }
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            APIResource.handleAPIError(rBody, rCode);
        }
        return (T)GSON.fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, APIException, ChannelException {
        Error error = ((ErrorContainer)GSON.fromJson(rBody, ErrorContainer.class)).error;
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 402: {
                throw new ChannelException(error.message, error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.message);
            }
        }
        throw new APIException(error.message, null);
    }

    private static PingppResponse makeAppEngineRequest(RequestMethod method, String url, String query, String apiKey) throws APIException {
        String unknownErrorMessage = "Sorry, an unknown error occurred while trying to use the Google App Engine runtime. Please contact support@pingxx.com for assistance.";
        try {
            if (method == RequestMethod.GET || method == RequestMethod.DELETE) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            Object fetchOptions = null;
            try {
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Warning: this App Engine SDK version does not allow verification of SSL certificates;this exposes you to a MITM attack. Please upgrade your App Engine SDK to >=1.5.0. If you have questions, contact support@pingxx.com.");
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("withDefaults", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            fetchOptionsClass.getDeclaredMethod("setDeadline", Double.class).invoke(fetchOptions, new Double(55.0));
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if (method == RequestMethod.POST) {
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{query.getBytes()});
            }
            for (Map.Entry<String, String> header : APIResource.getHeaders(apiKey).entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(header.getKey(), header.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object urlFetchService = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = urlFetchService.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(urlFetchService, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String body = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), CHARSET);
            return new PingppResponse(responseCode, body);
        }
        catch (InvocationTargetException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (MalformedURLException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (SecurityException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (ClassNotFoundException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (IllegalArgumentException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (InstantiationException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new APIException(unknownErrorMessage, e);
        }
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

