/*
 * Decompiled with CFR 0.152.
 */
package cn.ljguo.java.net;

import cn.ljguo.java.net.JGSocketListener;
import cn.ljguo.java.net.JGSocketParams;
import java.io.InputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;

public class JGSocket {
    private InputStream is;
    private Socket socket;
    private JGSocketParams socketParams = new JGSocketParams();
    private JGSocketListener.OnSocketConnectListener onSocketConnectListener;
    private JGSocketListener.OnSocketDataListener onSocketDataListener;
    private Timer timer;
    private Integer nowSendHeartbeatErrorRetryCount = 0;
    private boolean isCloseReceiveData = false;

    public JGSocketListener.OnSocketDataListener getOnSocketDataListener() {
        return this.onSocketDataListener;
    }

    public void setOnSocketDataListener(JGSocketListener.OnSocketDataListener onSocketDataListener) {
        this.onSocketDataListener = onSocketDataListener;
    }

    public JGSocketListener.OnSocketConnectListener getOnSocketConnectListener() {
        return this.onSocketConnectListener;
    }

    public void setOnSocketConnectListener(JGSocketListener.OnSocketConnectListener onSocketConnectListener) {
        this.onSocketConnectListener = onSocketConnectListener;
    }

    public JGSocketParams getSocketParams() {
        return this.socketParams;
    }

    public void setSocketParams(JGSocketParams socketParams) {
        this.socketParams = socketParams;
    }

    public JGSocket() {
    }

    public JGSocket(String hostName, Integer port) {
        this.socketParams.setHostName(hostName);
        this.socketParams.setPort(port);
    }

    public void connect(final String hostName, final Integer port, final JGSocketListener.OnSocketConnectListener onSocketConnectListener) {
        this.onSocketConnectListener = onSocketConnectListener;
        this.socketParams.setHostName(hostName);
        this.socketParams.setPort(port);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        JGSocket.this.socket = new Socket(JGSocket.this.socketParams.getHostName(), (int)JGSocket.this.socketParams.getPort());
                        if (JGSocket.this.socket.isConnected()) {
                            JGSocket.this.socketParams.setRepetitionInterval(0L);
                            JGSocket.this.connectSuccess();
                            break block6;
                        }
                        if (JGSocket.this.socketParams.isRepetition()) {
                            if (JGSocket.this.socketParams.getRepetitionNowCount() > JGSocket.this.socketParams.getRepetitionCount()) break block6;
                            try {
                                Thread.sleep(JGSocket.this.socketParams.getRepetitionInterval());
                            }
                            catch (InterruptedException e) {
                                JGSocket.this.connectError(0, e.toString());
                            }
                            JGSocket.this.socketParams.setRepetitionNowCount(JGSocket.this.socketParams.getRepetitionNowCount() + 1);
                            JGSocket.this.connect(hostName, port, onSocketConnectListener);
                            break block6;
                        }
                        JGSocket.this.connectError(4, "\u95be\u70ac\u5e34\u6fb6\u8fab\u89e6");
                    }
                    catch (Exception e) {
                        JGSocket.this.connectError(0, e.toString());
                    }
                }
            }
        }).start();
    }

    public void startHeartbeat(int interval, final byte[] heartbeat) {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JGSocket.this.sendData(heartbeat, new JGSocketListener.OnSocketSendDataListener(){

                    @Override
                    public void success() {
                        JGSocket.this.nowSendHeartbeatErrorRetryCount = 0;
                    }

                    @Override
                    public void error() {
                        if ((JGSocket.this.nowSendHeartbeatErrorRetryCount = JGSocket.this.nowSendHeartbeatErrorRetryCount + 1) > JGSocket.this.socketParams.getSendHeartbeatErrorRetryCount()) {
                            JGSocket.this.timer.cancel();
                        }
                    }
                });
            }
        }, 0L, (long)interval);
    }

    public void stopHeartbeat() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void close(JGSocketListener.OnSocketStatusListener onSocketStatusListener) {
        block3: {
            try {
                this.isCloseReceiveData = true;
                this.is.close();
                this.socket.close();
                if (onSocketStatusListener != null) {
                    onSocketStatusListener.close();
                }
            }
            catch (Exception e) {
                if (onSocketStatusListener == null) break block3;
                onSocketStatusListener.closeError();
            }
        }
    }

    public void receive() {
        this.isCloseReceiveData = false;
        try {
            this.is = this.socket.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JGSocket.this.socket.isClosed() && JGSocket.this.socket.isConnected()) {
                    if (JGSocket.this.isCloseReceiveData) {
                        return;
                    }
                    try {
                        int available = JGSocket.this.is.available();
                        if (available == 0) {
                            Thread.sleep(100L);
                            continue;
                        }
                        byte[] bytes = new byte[available];
                        JGSocket.this.is.read(bytes);
                        JGSocket.this.result(bytes);
                    }
                    catch (Exception exception) {}
                }
            }
        }).start();
    }

    public void closeReceive() {
        this.isCloseReceiveData = true;
    }

    public boolean isCloseReceiveData() {
        return this.isCloseReceiveData;
    }

    public void sendData(final byte[] data, final JGSocketListener.OnSocketSendDataListener onSocketSendDataListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (JGSocket.this.socket.isConnected()) {
                        try {
                            JGSocket.this.socket.getOutputStream().write(data);
                            JGSocket.this.socket.getOutputStream().flush();
                            if (onSocketSendDataListener != null) {
                                onSocketSendDataListener.success();
                            }
                        }
                        catch (Exception e) {
                            if (onSocketSendDataListener == null) break block4;
                            onSocketSendDataListener.error();
                        }
                    }
                }
            }
        }).start();
    }

    private void connectError(Integer type, String exp) {
        if (this.onSocketConnectListener != null) {
            this.onSocketConnectListener.error(type, exp);
        }
    }

    private void connectSuccess() {
        this.receive();
        if (this.onSocketConnectListener != null) {
            this.onSocketConnectListener.success();
        }
    }

    private void result(byte[] b) {
        if (this.onSocketDataListener != null) {
            this.onSocketDataListener.data(b);
        }
    }
}

