/*
 * Decompiled with CFR 0.152.
 */
package cn.ljguo.java.net;

import cn.ljguo.java.net.JGUDPListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class JGDatagramSocket {
    private static DatagramSocket client;
    private static boolean isReceive;
    private static boolean closeReceive;
    private static final int TIMEOUT = 10000;

    private void init() throws SocketException {
        if (client == null) {
            client = new DatagramSocket();
        }
        if (client.isClosed()) {
            client = new DatagramSocket();
        }
        client.setSoTimeout(10000);
    }

    public void send(final String ip, final int port, final byte[] data, final JGUDPListener.OnSocketSendDataListener socketSendDataListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        JGDatagramSocket.this.init();
                        InetAddress address = InetAddress.getByName(ip);
                        DatagramPacket sendPacket = new DatagramPacket(data, data.length, address, port);
                        client.send(sendPacket);
                        if (socketSendDataListener != null) {
                            socketSendDataListener.success(ip, port);
                        }
                    }
                    catch (UnknownHostException e) {
                        if (socketSendDataListener != null) {
                            socketSendDataListener.error(ip, port, e);
                        }
                    }
                    catch (IOException e) {
                        if (socketSendDataListener == null) break block5;
                        socketSendDataListener.error(ip, port, e);
                    }
                }
            }
        }).start();
    }

    public void closeReceive() {
        if (client != null) {
            System.out.print("\u934f\u62bd\u68f4\u93c1\u7248\u5d41\u7487\u8bf2\u5f47");
            closeReceive = true;
            client.disconnect();
            client.close();
        }
    }

    public void receive(final JGUDPListener.OnSocketDataListener socketDataListener) {
        if (!isReceive) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JGDatagramSocket.this.init();
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                    }
                    closeReceive = false;
                    while (!closeReceive) {
                        boolean isReceiveData = false;
                        byte[] receiveBuf = new byte[1024];
                        DatagramPacket receivePacket = new DatagramPacket(receiveBuf, receiveBuf.length);
                        try {
                            client.receive(receivePacket);
                            isReceiveData = true;
                        }
                        catch (IOException e) {
                            if (!SocketTimeoutException.class.equals(e.getClass())) break;
                        }
                        if (!isReceiveData) continue;
                        byte[] data = Arrays.copyOf(receivePacket.getData(), receivePacket.getLength());
                        if (socketDataListener == null) continue;
                        socketDataListener.data(receivePacket.getAddress().getHostAddress(), 0, data);
                    }
                    isReceive = false;
                    if (socketDataListener != null) {
                        socketDataListener.disconnect("", 0);
                    }
                }
            }).start();
        }
    }

    static {
        isReceive = false;
        closeReceive = false;
    }
}

