package com.eastagile.cibridge;

import android.util.Log;

import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by Tinh Nguyen on 4/30/16.
 * Copyright (c) 2016 Tinh Nguyen. All rights reserved.
 */
public abstract class CiBridge {
    private static final String RESPONSE_TAG = "CiBridge-Response";
    protected static CiBridge instance;
    private BridgeService mService;

    protected CiBridge(String adbServer) {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(interceptor).build();
        Retrofit retrofit = new Retrofit.Builder().client(client).baseUrl(adbServer).addConverterFactory(GsonConverterFactory.create())
                .build();
        mService = retrofit.create(BridgeService.class);
    }

    private void screenshot(String tag, String trace) {
        Screenshot screenshot = new Screenshot(tag, trace);
        Call<ResponseBody> call = mService.takeScreenshot(screenshot);
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                Log.d(RESPONSE_TAG, "" + response.body());
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {
                Log.e(RESPONSE_TAG, "" + t.getMessage());
            }
        });
    }

    private void unlock() {
        Call<ResponseBody> call = mService.unlockScreen();
        call.enqueue(new Callback<ResponseBody>() {
            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {}

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable t) {}
        });
    }

    public static void unlockScreen() {
        instance.unlock();
    }

    public static void takeScreenshot(String tag, String trace) {
        instance.screenshot(tag, trace);
    }
}
