package com.ardmn.circlediagramlibrary;

import android.graphics.Color;

/**
 * Created by MrLero on 23.04.2015.
 */
public class Sector
{
    int color;
    float percent;
    int degrees;

    public Sector()
    {}

    public Sector(int color, float percent) {
        this.color = color;
        this.percent = percent;
    }

    public Sector(int color, float percent, int degrees) {
        this.color = color;
        this.percent = percent;
        this.degrees = degrees;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public float getPercent() {
        return percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
    }

    public int getDegrees() {
        return degrees;
    }

    public void setDegrees(int degrees) {
        this.degrees = degrees;
    }

    public Sector(String color, String percent) {
        this.color = Color.parseColor(color);
        this.percent = Float.valueOf(percent);

        if( this.percent<0.0f || this.percent>1.0f)
            throw new IllegalArgumentException("      (0,1)");
    }

    public Sector clone()
    {
        return  new Sector(color ,percent,degrees);
    }
}
