package com.ardmn.circlediagramlibrary;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;


//com.ardmn.foodcircleview.MyView

/**
 * Created by Ardmn on 22.04.2015.
 */
public class FoodCircleView extends View {

    public FoodCircleView(Context context) {
        super(context);
    }

    private int sectorsLineWidth = 2;
    private int backgroundCircleColor = Color.BLACK;
    private int backgroundContentColor = Color.WHITE;
    private int startSectorsAngle = 0;
    private ArrayList<Sector> sectors = new ArrayList<Sector>();

    public FoodCircleView(Context context, AttributeSet attrs) {
        super(context, attrs);

        initXmlParams(context, attrs);

    }

    public FoodCircleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        initXmlParams(context, attrs);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public FoodCircleView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);

        initXmlParams(context, attrs);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();

    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        // Try for a width based on our minimum
        int minw = getPaddingLeft() + getPaddingRight() + getSuggestedMinimumWidth();
        int w = resolveSizeAndState(minw, widthMeasureSpec, 1);

        // Whatever the width ends up being, ask for a height that would let the pie
        // get as big as it can
        int minh = MeasureSpec.getSize(w) + getPaddingBottom() + getPaddingTop();
        int h = resolveSizeAndState(MeasureSpec.getSize(w), heightMeasureSpec, 0);

        setMeasuredDimension(Math.min(w, h), Math.min(w, h));
        //super.onMeasure(widthMeasureSpec, heightMeasureSpec);

    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        System.out.println("onSizeChanged:" + w + " " + h + " " + oldw + "oldh");
    }


    private void initXmlParams(Context context, AttributeSet attrs) {
        final TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.FoodCircle, 0, 0);

        try {

            sectorsLineWidth = array.getDimensionPixelSize(R.styleable.FoodCircle_sectorsLineWidth, sectorsLineWidth);
            backgroundCircleColor = array.getColor(R.styleable.FoodCircle_backgroundCircleColor, backgroundCircleColor);
            backgroundContentColor = array.getColor(R.styleable.FoodCircle_backgroundContentColor, backgroundContentColor);
            startSectorsAngle = array.getInteger(R.styleable.FoodCircle_startSectorsAngle, startSectorsAngle);


            final int sectorsDataId = array.getResourceId(R.styleable.FoodCircle_sectorsData, -1);
            String params[] = null;
            if (sectorsDataId > 0 && !isInEditMode()) {
                params = getResources().getStringArray(sectorsDataId);
            } else if (!isInEditMode()) {
                String dataSrt = array.getString(R.styleable.FoodCircle_sectorsData);

                if (dataSrt != null) {
                    params = new String[1];
                    params[0] = dataSrt;
                }
            } else {
                params = new String[1];
                params[0] = "0.6-#FF0000";
            }

            parseParams(params);

        } finally {

            array.recycle();
        }
    }

    private void parseParams(String params[]) {
        if (params == null)
            return;

        for (int i = 0; i < params.length; i++) {
            String values[] = params[i].split("-");

            if (values.length != 2)
                throw new IllegalArgumentException(i + "я строка аргументов имеет неверный формат");

            sectors.add(new Sector(values[1], values[0]));
        }
    }

    protected void onDraw(Canvas canvas) {

        try {


            calcDegreesForEachSector();

            final int getMaxCircleRadius = Math.min(getHeight(), getWidth()) / 2;
            final int currentHeight = getHeight();
            final int currentWidth = getWidth();
            final Rect maxCircleRect = new Rect();
            maxCircleRect.set(0, 0, getMaxCircleRadius * 2, getMaxCircleRadius * 2);


            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(backgroundCircleColor);
            canvas.drawOval(new RectF(maxCircleRect), paint);

            if (animationFlag != null && !animationFlag.get() || sectorsForAnimation == null) {

                int curDegrees = startSectorsAngle;
                for (int i = 0; i < sectors.size(); i++) {
                    paint.setColor(sectors.get(i).getColor());
                    canvas.drawArc(new RectF(maxCircleRect), curDegrees, sectors.get(i).getDegrees() + 1, true, paint);
                    curDegrees += sectors.get(i).getDegrees();
                }
            } else {
                int curDegrees = startSectorsAngle;
                for (int i = 0; i < sectors.size(); i++) {
                    paint.setColor(sectors.get(i).getColor());
                    canvas.drawArc(new RectF(maxCircleRect), curDegrees, sectorsForAnimation.get(i).getDegrees() + 1, true, paint);
                    curDegrees += sectors.get(i).getDegrees();
                }
            }

            paint.setColor(backgroundContentColor);
            final Rect contentCircleRect = new Rect();
            contentCircleRect.set(sectorsLineWidth, sectorsLineWidth, getMaxCircleRadius * 2 - sectorsLineWidth, getMaxCircleRadius * 2 - sectorsLineWidth);
            canvas.drawOval(new RectF(contentCircleRect), paint);

        } catch (Exception e) {
            e.printStackTrace();

            if(animationFlag !=null)
                animationFlag.set(false);

        }

    }

    private void calcDegreesForEachSector() {
        float persentsSum = 0.0f;
        for (int i = 0; i < sectors.size(); i++) {
            persentsSum += Math.abs(sectors.get(i).getPercent());
        }

        if (persentsSum < 0.0 && persentsSum > 1.0) {
            float valueForOnePercent = persentsSum / 100.0f;
            for (int i = 0; i < sectors.size(); i++) {
                sectors.get(i).setPercent(Math.abs(sectors.get(i).getPercent()) / valueForOnePercent);
            }
        }

        int sumDegrees = 0;
        int maxDegrees = -1;
        int maxDegreesIndex = -1;

        for (int i = 0; i < sectors.size(); i++) {
            sectors.get(i).setDegrees((int) (360.0f * sectors.get(i).getPercent()));
            sumDegrees += sectors.get(i).getDegrees();

            if (maxDegrees < sectors.get(i).getDegrees()) {
                maxDegrees = sectors.get(i).getDegrees();
                maxDegreesIndex = i;
            }
        }

        if (persentsSum == 1.0f && sumDegrees != 360 && maxDegreesIndex > -1) {
            sectors.get(maxDegreesIndex).setDegrees(maxDegrees + (360 - sumDegrees));
        }
    }

    public int getSectorsLineWidth() {
        return sectorsLineWidth;
    }

    public void setSectorsLineWidth(int sectorsLineWidth) {
        this.sectorsLineWidth = sectorsLineWidth;
    }

    public int getBackgroundCircleColor() {
        return backgroundCircleColor;
    }

    public void setBackgroundCircleColor(int backgroundColor) {
        this.backgroundCircleColor = backgroundColor;
    }

    public int getBackgroundContentColor() {
        return backgroundContentColor;
    }

    public void setBackgroundContentColor(int backgroundContentColor) {
        this.backgroundContentColor = backgroundContentColor;
    }

    public int getStartSectorsAngle() {
        return startSectorsAngle;
    }

    public void setStartSectorsAngle(int startSectorsAngle) {
        this.startSectorsAngle = startSectorsAngle;
    }

    public ArrayList<Sector> getSectors() {
        return sectors;
    }

    public void setSectors(ArrayList<Sector> sectors) {
        this.sectors = sectors;
    }

    public long getAminationDuration() {
        return aminationDuration;
    }

    public void setAminationDuration(long aminationDuration) {
        this.aminationDuration = aminationDuration;
    }

    private Animator animator = null;
    private long aminationDuration = 0;
    private static volatile AtomicBoolean animationFlag = new AtomicBoolean(false);

    public void startAnimation() {
        stopAnimation();
        animator = new Animator(this, true, getAminationDuration());
        animator.setiUpdateAnimator(iUpdateAnimator);

        sectorsForAnimation = new ArrayList<Sector>();
        for (int i = 0; i < sectors.size(); i++)
            sectorsForAnimation.add(sectors.get(i).clone());

        animationFlag.set(true);
        post(animator);
    }


    public void stopAnimation() {
        if (animator != null)
            animator.setFlag(false);

        if (sectorsForAnimation != null)
            sectorsForAnimation.clear();

        sectorsForAnimation = null;
        animator = null;

        animationFlag.set(false);
    }

    private class Animator implements Runnable {

        private final long UPDATE_DELEY = 16;

        private boolean flag = false;
        private long duration = 0;
        private View view = null;
        private IUpdateAnimator iUpdateAnimator = null;

        private int stepCount = 1;
        private int currStep = 1;

        Animator() {

        }


        Animator(View view) {
            this.view = view;
        }

        Animator(View view, boolean flag) {
            this.view = view;
            this.flag = flag;
        }

        Animator(View view, boolean flag, long duration) {
            this.view = view;
            this.flag = flag;
            this.duration = duration;

            stepCount = (int) (duration / UPDATE_DELEY) + 1;
            currStep = 0;
        }

        public void run() {

            currStep++;

            if (view != null) {

                iUpdateAnimator.updateData(stepCount, currStep);// первый шаг должен быть равен 1
                view.invalidate();
                if (flag && currStep <= stepCount)
                    view.postDelayed(this, UPDATE_DELEY);
                else {

                }
            }
        }

        public boolean isFlag() {
            return flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }

        public long getDuration() {
            return duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public IUpdateAnimator getiUpdateAnimator() {
            return iUpdateAnimator;
        }

        public void setiUpdateAnimator(IUpdateAnimator iUpdateAnimator) {
            this.iUpdateAnimator = iUpdateAnimator;
        }
    }

    private interface IUpdateAnimator {
        public void updateData(int stepCount, int currStep);
    }

    IUpdateAnimator iUpdateAnimator = new IUpdateAnimator() {

        @Override
        public void updateData(int stepCount, int currStep) {

            if (sectorsForAnimation != null && sectors != null && sectorsForAnimation.size() == sectors.size()) {

                for (int i = 0; i < sectorsForAnimation.size(); i++)
                    sectorsForAnimation.get(i).setDegrees((int) (((float) currStep / (float) stepCount) * (float) sectors.get(i).getDegrees()));
            }
        }
    };

    private ArrayList<Sector> sectorsForAnimation = null;
}
