package com.ardmn.circlediagramlibrary;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

/**
 * Created by Ardmn on 23.04.2015.
 */
public class FoodCircleComponent extends RelativeLayout {

    private  FoodCircleView foodCircleView = null;
    private LinearLayout page_indicator_container = null;
    private View page_indicator_1=null,page_indicator_2=null;

    public FoodCircleComponent(Context context) {
        super(context);

        initComponent();
    }

    public FoodCircleComponent(Context context, AttributeSet attrs) {
        super(context, attrs);

        initComponent();

    }

    public FoodCircleComponent(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        initComponent();
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public FoodCircleComponent(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);

        initComponent();
    }


    private  RelativeLayout circle_view_content_conteiner = null;
    private  View simpleDataView = null;

    private void initComponent() {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rootView = inflater.inflate(R.layout.food_circle_component_layout, this);

        foodCircleView = (FoodCircleView)rootView.findViewById(R.id.foodCircleView);

        circle_view_content_conteiner = (RelativeLayout)rootView.findViewById(R.id.circle_view_content_conteiner);
        page_indicator_container = (LinearLayout)rootView.findViewById(R.id.page_indicator_container);
        page_indicator_1 = rootView.findViewById(R.id.page_indicator_1);
        page_indicator_2 = rootView.findViewById(R.id.page_indicator_2);

      //  if(!isInEditMode())
            page_indicator_container.setVisibility(View.VISIBLE);

        simpleDataView = inflater.inflate(R.layout.food_circle_data_item, null);



    }



    public FoodCircleView getFoodCircleView() {
        return foodCircleView;
    }

    public void setFoodCircleView(FoodCircleView foodCircleView) {
        this.foodCircleView = foodCircleView;
    }


    private BaseAdapter baseAdapter = null;

    public BaseAdapter getBaseAdapter() {
        return baseAdapter;
    }

    public void setBaseAdapter(BaseAdapter baseAdapter) {
        this.baseAdapter = null;
        this.baseAdapter = baseAdapter;

        notifyDataHasChanged();
    }

    private int currentItemIndex =0;
    public void notifyDataHasChanged()
    {

        if( circle_view_content_conteiner != null) {



            if (baseAdapter != null)
            {
                currentItemIndex  = 0;

                showView(currentItemIndex);

                if(baseAdapter.getCount() > 1)
                {
                    setFootterIndicator(currentItemIndex);
                }

            }
            else
            {
                circle_view_content_conteiner.addView(simpleDataView);
            }
        }

        invalidate();
    }

    private void setFootterIndicator(int currentItemIndex)
    {
        if(page_indicator_container.getVisibility() == View.INVISIBLE)
            page_indicator_container.setVisibility(View.VISIBLE);

        if(currentItemIndex % 2 == 0) {
            page_indicator_1.setSelected(true);
            page_indicator_2.setSelected(false);
        }
        else
        {
            page_indicator_1.setSelected(false);
            page_indicator_2.setSelected(true);
        }
    }

    private void showView(int index)
    {

        if(baseAdapter.getCount() > 0) {

            final int curViewIndex = getCurrentItemIndex();
            final int curViewCount = baseAdapter.getCount();

            circle_view_content_conteiner.removeAllViews();

            View view = baseAdapter.getView(index, null, null);
            view.setOnClickListener(onClickListener);


           LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            params.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);
            view.setLayoutParams(params);

            circle_view_content_conteiner.addView(view);
        }

        if(baseAdapter.getCount() > 1)
        {
            setFootterIndicator(index);
        }

    }

    public int getCurrentItemIndex() {
        return currentItemIndex;
    }

    OnClickListener onClickListener = new OnClickListener() {
        @Override
        public void onClick(View view) {

            final int curViewCount = baseAdapter.getCount();
            currentItemIndex = (currentItemIndex+1)%curViewCount;
            showView(currentItemIndex);
        }
    };

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b)
    {

        super.onLayout(changed,l,t,r,b);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec)
    {

        super.onMeasure(widthMeasureSpec,heightMeasureSpec);

        int curH = circle_view_content_conteiner.getHeight();
       // int curW = circle_view_content_conteiner.getWidth();
       // int conteinerH = page_indicator_container.getHeight();

        if(isInEditMode())
        {
            curH = Math.max(curH,200);
        }

        int indicatorSize = curH /20;
        int conteinerSize = indicatorSize * 2 + foodCircleView.getSectorsLineWidth();

        LinearLayout.LayoutParams params ;

        params = (LinearLayout.LayoutParams)page_indicator_1.getLayoutParams();
        params.height = indicatorSize;
        params.width = indicatorSize;
        params.rightMargin = indicatorSize /2;
        page_indicator_1.setLayoutParams(params);



        params = (LinearLayout.LayoutParams)page_indicator_2.getLayoutParams();
        params.height = indicatorSize;
        params.width = indicatorSize;
        params.leftMargin = indicatorSize /2;
        page_indicator_2.setLayoutParams(params);


        page_indicator_container.getLayoutParams().height = conteinerSize;



    }
}
